/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wisdom.model.QuickResponseFilterField;
import software.amazon.awssdk.services.wisdom.model.QuickResponseFilterFieldListCopier;
import software.amazon.awssdk.services.wisdom.model.QuickResponseOrderField;
import software.amazon.awssdk.services.wisdom.model.QuickResponseQueryField;
import software.amazon.awssdk.services.wisdom.model.QuickResponseQueryFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuickResponseSearchExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuickResponseSearchExpression> {
    private static final SdkField<List<QuickResponseFilterField>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(QuickResponseSearchExpression.getter(QuickResponseSearchExpression::filters)).setter(QuickResponseSearchExpression.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuickResponseFilterField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<QuickResponseOrderField> ORDER_ON_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orderOnField").getter(QuickResponseSearchExpression.getter(QuickResponseSearchExpression::orderOnField)).setter(QuickResponseSearchExpression.setter(Builder::orderOnField)).constructor(QuickResponseOrderField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderOnField").build()}).build();
    private static final SdkField<List<QuickResponseQueryField>> QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queries").getter(QuickResponseSearchExpression.getter(QuickResponseSearchExpression::queries)).setter(QuickResponseSearchExpression.setter(Builder::queries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuickResponseQueryField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, ORDER_ON_FIELD_FIELD, QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("filters", FILTERS_FIELD);
            this.put("orderOnField", ORDER_ON_FIELD_FIELD);
            this.put("queries", QUERIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<QuickResponseFilterField> filters;
    private final QuickResponseOrderField orderOnField;
    private final List<QuickResponseQueryField> queries;

    private QuickResponseSearchExpression(BuilderImpl builder) {
        this.filters = builder.filters;
        this.orderOnField = builder.orderOnField;
        this.queries = builder.queries;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<QuickResponseFilterField> filters() {
        return this.filters;
    }

    public final QuickResponseOrderField orderOnField() {
        return this.orderOnField;
    }

    public final boolean hasQueries() {
        return this.queries != null && !(this.queries instanceof SdkAutoConstructList);
    }

    public final List<QuickResponseQueryField> queries() {
        return this.queries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.orderOnField());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueries() ? this.queries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickResponseSearchExpression)) {
            return false;
        }
        QuickResponseSearchExpression other = (QuickResponseSearchExpression)obj;
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.orderOnField(), other.orderOnField()) && this.hasQueries() == other.hasQueries() && Objects.equals(this.queries(), other.queries());
    }

    public final String toString() {
        return ToString.builder((String)"QuickResponseSearchExpression").add("Filters", this.hasFilters() ? this.filters() : null).add("OrderOnField", (Object)this.orderOnField()).add("Queries", this.hasQueries() ? this.queries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "orderOnField": {
                return Optional.ofNullable(clazz.cast(this.orderOnField()));
            }
            case "queries": {
                return Optional.ofNullable(clazz.cast(this.queries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QuickResponseSearchExpression, T> g) {
        return obj -> g.apply((QuickResponseSearchExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<QuickResponseFilterField> filters = DefaultSdkAutoConstructList.getInstance();
        private QuickResponseOrderField orderOnField;
        private List<QuickResponseQueryField> queries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuickResponseSearchExpression model) {
            this.filters(model.filters);
            this.orderOnField(model.orderOnField);
            this.queries(model.queries);
        }

        public final List<QuickResponseFilterField.Builder> getFilters() {
            List<QuickResponseFilterField.Builder> result = QuickResponseFilterFieldListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<QuickResponseFilterField.BuilderImpl> filters) {
            this.filters = QuickResponseFilterFieldListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<QuickResponseFilterField> filters) {
            this.filters = QuickResponseFilterFieldListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(QuickResponseFilterField ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<QuickResponseFilterField.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (QuickResponseFilterField)((QuickResponseFilterField.Builder)QuickResponseFilterField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final QuickResponseOrderField.Builder getOrderOnField() {
            return this.orderOnField != null ? this.orderOnField.toBuilder() : null;
        }

        public final void setOrderOnField(QuickResponseOrderField.BuilderImpl orderOnField) {
            this.orderOnField = orderOnField != null ? orderOnField.build() : null;
        }

        @Override
        public final Builder orderOnField(QuickResponseOrderField orderOnField) {
            this.orderOnField = orderOnField;
            return this;
        }

        public final List<QuickResponseQueryField.Builder> getQueries() {
            List<QuickResponseQueryField.Builder> result = QuickResponseQueryFieldListCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<QuickResponseQueryField.BuilderImpl> queries) {
            this.queries = QuickResponseQueryFieldListCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<QuickResponseQueryField> queries) {
            this.queries = QuickResponseQueryFieldListCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(QuickResponseQueryField ... queries) {
            this.queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<QuickResponseQueryField.Builder> ... queries) {
            this.queries(Stream.of(queries).map(c -> (QuickResponseQueryField)((QuickResponseQueryField.Builder)QuickResponseQueryField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public QuickResponseSearchExpression build() {
            return new QuickResponseSearchExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuickResponseSearchExpression> {
        public Builder filters(Collection<QuickResponseFilterField> var1);

        public Builder filters(QuickResponseFilterField ... var1);

        public Builder filters(Consumer<QuickResponseFilterField.Builder> ... var1);

        public Builder orderOnField(QuickResponseOrderField var1);

        default public Builder orderOnField(Consumer<QuickResponseOrderField.Builder> orderOnField) {
            return this.orderOnField((QuickResponseOrderField)((QuickResponseOrderField.Builder)QuickResponseOrderField.builder().applyMutation(orderOnField)).build());
        }

        public Builder queries(Collection<QuickResponseQueryField> var1);

        public Builder queries(QuickResponseQueryField ... var1);

        public Builder queries(Consumer<QuickResponseQueryField.Builder> ... var1);
    }
}

