/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wisdom.model.Priority;
import software.amazon.awssdk.services.wisdom.model.QuickResponseQueryOperator;
import software.amazon.awssdk.services.wisdom.model.QuickResponseQueryValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuickResponseQueryField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuickResponseQueryField> {
    private static final SdkField<Boolean> ALLOW_FUZZINESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowFuzziness").getter(QuickResponseQueryField.getter(QuickResponseQueryField::allowFuzziness)).setter(QuickResponseQueryField.setter(Builder::allowFuzziness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowFuzziness").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(QuickResponseQueryField.getter(QuickResponseQueryField::name)).setter(QuickResponseQueryField.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operator").getter(QuickResponseQueryField.getter(QuickResponseQueryField::operatorAsString)).setter(QuickResponseQueryField.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final SdkField<String> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("priority").getter(QuickResponseQueryField.getter(QuickResponseQueryField::priorityAsString)).setter(QuickResponseQueryField.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(QuickResponseQueryField.getter(QuickResponseQueryField::values)).setter(QuickResponseQueryField.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FUZZINESS_FIELD, NAME_FIELD, OPERATOR_FIELD, PRIORITY_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("allowFuzziness", ALLOW_FUZZINESS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("operator", OPERATOR_FIELD);
            this.put("priority", PRIORITY_FIELD);
            this.put("values", VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean allowFuzziness;
    private final String name;
    private final String operator;
    private final String priority;
    private final List<String> values;

    private QuickResponseQueryField(BuilderImpl builder) {
        this.allowFuzziness = builder.allowFuzziness;
        this.name = builder.name;
        this.operator = builder.operator;
        this.priority = builder.priority;
        this.values = builder.values;
    }

    public final Boolean allowFuzziness() {
        return this.allowFuzziness;
    }

    public final String name() {
        return this.name;
    }

    public final QuickResponseQueryOperator operator() {
        return QuickResponseQueryOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final Priority priority() {
        return Priority.fromValue(this.priority);
    }

    public final String priorityAsString() {
        return this.priority;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowFuzziness());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.priorityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickResponseQueryField)) {
            return false;
        }
        QuickResponseQueryField other = (QuickResponseQueryField)obj;
        return Objects.equals(this.allowFuzziness(), other.allowFuzziness()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && Objects.equals(this.priorityAsString(), other.priorityAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"QuickResponseQueryField").add("AllowFuzziness", (Object)this.allowFuzziness()).add("Name", (Object)this.name()).add("Operator", (Object)this.operatorAsString()).add("Priority", (Object)this.priorityAsString()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowFuzziness": {
                return Optional.ofNullable(clazz.cast(this.allowFuzziness()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priorityAsString()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QuickResponseQueryField, T> g) {
        return obj -> g.apply((QuickResponseQueryField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allowFuzziness;
        private String name;
        private String operator;
        private String priority;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuickResponseQueryField model) {
            this.allowFuzziness(model.allowFuzziness);
            this.name(model.name);
            this.operator(model.operator);
            this.priority(model.priority);
            this.values(model.values);
        }

        public final Boolean getAllowFuzziness() {
            return this.allowFuzziness;
        }

        public final void setAllowFuzziness(Boolean allowFuzziness) {
            this.allowFuzziness = allowFuzziness;
        }

        @Override
        public final Builder allowFuzziness(Boolean allowFuzziness) {
            this.allowFuzziness = allowFuzziness;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(QuickResponseQueryOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getPriority() {
            return this.priority;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public final Builder priority(Priority priority) {
            this.priority(priority == null ? null : priority.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = QuickResponseQueryValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = QuickResponseQueryValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public QuickResponseQueryField build() {
            return new QuickResponseQueryField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuickResponseQueryField> {
        public Builder allowFuzziness(Boolean var1);

        public Builder name(String var1);

        public Builder operator(String var1);

        public Builder operator(QuickResponseQueryOperator var1);

        public Builder priority(String var1);

        public Builder priority(Priority var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

