/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wisdom.model.ContentMetadataCopier;
import software.amazon.awssdk.services.wisdom.model.ContentStatus;
import software.amazon.awssdk.services.wisdom.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentData> {
    private static final SdkField<String> CONTENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentArn").getter(ContentData.getter(ContentData::contentArn)).setter(ContentData.setter(Builder::contentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentArn").build()}).build();
    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentId").getter(ContentData.getter(ContentData::contentId)).setter(ContentData.setter(Builder::contentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentId").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(ContentData.getter(ContentData::contentType)).setter(ContentData.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseArn").getter(ContentData.getter(ContentData::knowledgeBaseArn)).setter(ContentData.setter(Builder::knowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(ContentData.getter(ContentData::knowledgeBaseId)).setter(ContentData.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> LINK_OUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("linkOutUri").getter(ContentData.getter(ContentData::linkOutUri)).setter(ContentData.setter(Builder::linkOutUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkOutUri").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(ContentData.getter(ContentData::metadata)).setter(ContentData.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ContentData.getter(ContentData::name)).setter(ContentData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(ContentData.getter(ContentData::revisionId)).setter(ContentData.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ContentData.getter(ContentData::statusAsString)).setter(ContentData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ContentData.getter(ContentData::tags)).setter(ContentData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(ContentData.getter(ContentData::title)).setter(ContentData.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(ContentData.getter(ContentData::url)).setter(ContentData.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<Instant> URL_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("urlExpiry").getter(ContentData.getter(ContentData::urlExpiry)).setter(ContentData.setter(Builder::urlExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlExpiry").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ARN_FIELD, CONTENT_ID_FIELD, CONTENT_TYPE_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, LINK_OUT_URI_FIELD, METADATA_FIELD, NAME_FIELD, REVISION_ID_FIELD, STATUS_FIELD, TAGS_FIELD, TITLE_FIELD, URL_FIELD, URL_EXPIRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("contentArn", CONTENT_ARN_FIELD);
            this.put("contentId", CONTENT_ID_FIELD);
            this.put("contentType", CONTENT_TYPE_FIELD);
            this.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
            this.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
            this.put("linkOutUri", LINK_OUT_URI_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("name", NAME_FIELD);
            this.put("revisionId", REVISION_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("title", TITLE_FIELD);
            this.put("url", URL_FIELD);
            this.put("urlExpiry", URL_EXPIRY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String contentArn;
    private final String contentId;
    private final String contentType;
    private final String knowledgeBaseArn;
    private final String knowledgeBaseId;
    private final String linkOutUri;
    private final Map<String, String> metadata;
    private final String name;
    private final String revisionId;
    private final String status;
    private final Map<String, String> tags;
    private final String title;
    private final String url;
    private final Instant urlExpiry;

    private ContentData(BuilderImpl builder) {
        this.contentArn = builder.contentArn;
        this.contentId = builder.contentId;
        this.contentType = builder.contentType;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.linkOutUri = builder.linkOutUri;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.revisionId = builder.revisionId;
        this.status = builder.status;
        this.tags = builder.tags;
        this.title = builder.title;
        this.url = builder.url;
        this.urlExpiry = builder.urlExpiry;
    }

    public final String contentArn() {
        return this.contentArn;
    }

    public final String contentId() {
        return this.contentId;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String knowledgeBaseArn() {
        return this.knowledgeBaseArn;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String linkOutUri() {
        return this.linkOutUri;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final String name() {
        return this.name;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final ContentStatus status() {
        return ContentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String title() {
        return this.title;
    }

    public final String url() {
        return this.url;
    }

    public final Instant urlExpiry() {
        return this.urlExpiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkOutUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlExpiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentData)) {
            return false;
        }
        ContentData other = (ContentData)obj;
        return Objects.equals(this.contentArn(), other.contentArn()) && Objects.equals(this.contentId(), other.contentId()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.linkOutUri(), other.linkOutUri()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.urlExpiry(), other.urlExpiry());
    }

    public final String toString() {
        return ToString.builder((String)"ContentData").add("ContentArn", (Object)this.contentArn()).add("ContentId", (Object)this.contentId()).add("ContentType", (Object)this.contentType()).add("KnowledgeBaseArn", (Object)this.knowledgeBaseArn()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("LinkOutUri", (Object)this.linkOutUri()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("Name", (Object)this.name()).add("RevisionId", (Object)this.revisionId()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Title", (Object)this.title()).add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).add("UrlExpiry", (Object)this.urlExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentArn": {
                return Optional.ofNullable(clazz.cast(this.contentArn()));
            }
            case "contentId": {
                return Optional.ofNullable(clazz.cast(this.contentId()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "knowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseArn()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "linkOutUri": {
                return Optional.ofNullable(clazz.cast(this.linkOutUri()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "urlExpiry": {
                return Optional.ofNullable(clazz.cast(this.urlExpiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ContentData, T> g) {
        return obj -> g.apply((ContentData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentArn;
        private String contentId;
        private String contentType;
        private String knowledgeBaseArn;
        private String knowledgeBaseId;
        private String linkOutUri;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String name;
        private String revisionId;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String title;
        private String url;
        private Instant urlExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentData model) {
            this.contentArn(model.contentArn);
            this.contentId(model.contentId);
            this.contentType(model.contentType);
            this.knowledgeBaseArn(model.knowledgeBaseArn);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.linkOutUri(model.linkOutUri);
            this.metadata(model.metadata);
            this.name(model.name);
            this.revisionId(model.revisionId);
            this.status(model.status);
            this.tags(model.tags);
            this.title(model.title);
            this.url(model.url);
            this.urlExpiry(model.urlExpiry);
        }

        public final String getContentArn() {
            return this.contentArn;
        }

        public final void setContentArn(String contentArn) {
            this.contentArn = contentArn;
        }

        @Override
        public final Builder contentArn(String contentArn) {
            this.contentArn = contentArn;
            return this;
        }

        public final String getContentId() {
            return this.contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getLinkOutUri() {
            return this.linkOutUri;
        }

        public final void setLinkOutUri(String linkOutUri) {
            this.linkOutUri = linkOutUri;
        }

        @Override
        public final Builder linkOutUri(String linkOutUri) {
            this.linkOutUri = linkOutUri;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Instant getUrlExpiry() {
            return this.urlExpiry;
        }

        public final void setUrlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
        }

        @Override
        public final Builder urlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
            return this;
        }

        public ContentData build() {
            return new ContentData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentData> {
        public Builder contentArn(String var1);

        public Builder contentId(String var1);

        public Builder contentType(String var1);

        public Builder knowledgeBaseArn(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder linkOutUri(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder name(String var1);

        public Builder revisionId(String var1);

        public Builder status(String var1);

        public Builder status(ContentStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder title(String var1);

        public Builder url(String var1);

        public Builder urlExpiry(Instant var1);
    }
}

