/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.AccountJiraConfigurationInput;
import software.amazon.awssdk.services.wellarchitected.model.DiscoveryIntegrationStatus;
import software.amazon.awssdk.services.wellarchitected.model.OrganizationSharingStatus;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGlobalSettingsRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, UpdateGlobalSettingsRequest> {
    private static final SdkField<String> ORGANIZATION_SHARING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationSharingStatus").getter(UpdateGlobalSettingsRequest.getter(UpdateGlobalSettingsRequest::organizationSharingStatusAsString)).setter(UpdateGlobalSettingsRequest.setter(Builder::organizationSharingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationSharingStatus").build()}).build();
    private static final SdkField<String> DISCOVERY_INTEGRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryIntegrationStatus").getter(UpdateGlobalSettingsRequest.getter(UpdateGlobalSettingsRequest::discoveryIntegrationStatusAsString)).setter(UpdateGlobalSettingsRequest.setter(Builder::discoveryIntegrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryIntegrationStatus").build()}).build();
    private static final SdkField<AccountJiraConfigurationInput> JIRA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JiraConfiguration").getter(UpdateGlobalSettingsRequest.getter(UpdateGlobalSettingsRequest::jiraConfiguration)).setter(UpdateGlobalSettingsRequest.setter(Builder::jiraConfiguration)).constructor(AccountJiraConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_SHARING_STATUS_FIELD, DISCOVERY_INTEGRATION_STATUS_FIELD, JIRA_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateGlobalSettingsRequest.memberNameToFieldInitializer();
    private final String organizationSharingStatus;
    private final String discoveryIntegrationStatus;
    private final AccountJiraConfigurationInput jiraConfiguration;

    private UpdateGlobalSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.organizationSharingStatus = builder.organizationSharingStatus;
        this.discoveryIntegrationStatus = builder.discoveryIntegrationStatus;
        this.jiraConfiguration = builder.jiraConfiguration;
    }

    public final OrganizationSharingStatus organizationSharingStatus() {
        return OrganizationSharingStatus.fromValue(this.organizationSharingStatus);
    }

    public final String organizationSharingStatusAsString() {
        return this.organizationSharingStatus;
    }

    public final DiscoveryIntegrationStatus discoveryIntegrationStatus() {
        return DiscoveryIntegrationStatus.fromValue(this.discoveryIntegrationStatus);
    }

    public final String discoveryIntegrationStatusAsString() {
        return this.discoveryIntegrationStatus;
    }

    public final AccountJiraConfigurationInput jiraConfiguration() {
        return this.jiraConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationSharingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryIntegrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jiraConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalSettingsRequest)) {
            return false;
        }
        UpdateGlobalSettingsRequest other = (UpdateGlobalSettingsRequest)((Object)obj);
        return Objects.equals(this.organizationSharingStatusAsString(), other.organizationSharingStatusAsString()) && Objects.equals(this.discoveryIntegrationStatusAsString(), other.discoveryIntegrationStatusAsString()) && Objects.equals(this.jiraConfiguration(), other.jiraConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGlobalSettingsRequest").add("OrganizationSharingStatus", (Object)this.organizationSharingStatusAsString()).add("DiscoveryIntegrationStatus", (Object)this.discoveryIntegrationStatusAsString()).add("JiraConfiguration", (Object)this.jiraConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationSharingStatus": {
                return Optional.ofNullable(clazz.cast(this.organizationSharingStatusAsString()));
            }
            case "DiscoveryIntegrationStatus": {
                return Optional.ofNullable(clazz.cast(this.discoveryIntegrationStatusAsString()));
            }
            case "JiraConfiguration": {
                return Optional.ofNullable(clazz.cast(this.jiraConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrganizationSharingStatus", ORGANIZATION_SHARING_STATUS_FIELD);
        map.put("DiscoveryIntegrationStatus", DISCOVERY_INTEGRATION_STATUS_FIELD);
        map.put("JiraConfiguration", JIRA_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalSettingsRequest, T> g) {
        return obj -> g.apply((UpdateGlobalSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String organizationSharingStatus;
        private String discoveryIntegrationStatus;
        private AccountJiraConfigurationInput jiraConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalSettingsRequest model) {
            super(model);
            this.organizationSharingStatus(model.organizationSharingStatus);
            this.discoveryIntegrationStatus(model.discoveryIntegrationStatus);
            this.jiraConfiguration(model.jiraConfiguration);
        }

        public final String getOrganizationSharingStatus() {
            return this.organizationSharingStatus;
        }

        public final void setOrganizationSharingStatus(String organizationSharingStatus) {
            this.organizationSharingStatus = organizationSharingStatus;
        }

        @Override
        public final Builder organizationSharingStatus(String organizationSharingStatus) {
            this.organizationSharingStatus = organizationSharingStatus;
            return this;
        }

        @Override
        public final Builder organizationSharingStatus(OrganizationSharingStatus organizationSharingStatus) {
            this.organizationSharingStatus(organizationSharingStatus == null ? null : organizationSharingStatus.toString());
            return this;
        }

        public final String getDiscoveryIntegrationStatus() {
            return this.discoveryIntegrationStatus;
        }

        public final void setDiscoveryIntegrationStatus(String discoveryIntegrationStatus) {
            this.discoveryIntegrationStatus = discoveryIntegrationStatus;
        }

        @Override
        public final Builder discoveryIntegrationStatus(String discoveryIntegrationStatus) {
            this.discoveryIntegrationStatus = discoveryIntegrationStatus;
            return this;
        }

        @Override
        public final Builder discoveryIntegrationStatus(DiscoveryIntegrationStatus discoveryIntegrationStatus) {
            this.discoveryIntegrationStatus(discoveryIntegrationStatus == null ? null : discoveryIntegrationStatus.toString());
            return this;
        }

        public final AccountJiraConfigurationInput.Builder getJiraConfiguration() {
            return this.jiraConfiguration != null ? this.jiraConfiguration.toBuilder() : null;
        }

        public final void setJiraConfiguration(AccountJiraConfigurationInput.BuilderImpl jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration != null ? jiraConfiguration.build() : null;
        }

        @Override
        public final Builder jiraConfiguration(AccountJiraConfigurationInput jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalSettingsRequest build() {
            return new UpdateGlobalSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGlobalSettingsRequest> {
        public Builder organizationSharingStatus(String var1);

        public Builder organizationSharingStatus(OrganizationSharingStatus var1);

        public Builder discoveryIntegrationStatus(String var1);

        public Builder discoveryIntegrationStatus(DiscoveryIntegrationStatus var1);

        public Builder jiraConfiguration(AccountJiraConfigurationInput var1);

        default public Builder jiraConfiguration(Consumer<AccountJiraConfigurationInput.Builder> jiraConfiguration) {
            return this.jiraConfiguration((AccountJiraConfigurationInput)((AccountJiraConfigurationInput.Builder)AccountJiraConfigurationInput.builder().applyMutation(jiraConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

