/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QuestionType {
    PRIORITIZED("PRIORITIZED"),
    NON_PRIORITIZED("NON_PRIORITIZED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QuestionType> VALUE_MAP;
    private final String value;

    private QuestionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QuestionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QuestionType> knownValues() {
        EnumSet<QuestionType> knownValues = EnumSet.allOf(QuestionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QuestionType.class, QuestionType::toString);
    }
}

