/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public class S3PojoToV2
extends Recipe {
    private static final Pattern COMPETE_MPU = Pattern.compile("com.amazonaws.services.s3.model.CompleteMultipartUploadRequest");
    private static final Pattern OBJECT_TAGGING = Pattern.compile("com.amazonaws.services.s3.model.ObjectTagging");
    private static final Pattern GET_OBJECT_TAGGING_RESULT = Pattern.compile("com.amazonaws.services.s3.model.GetObjectTaggingResult");

    public String getDisplayName() {
        return "S3 POJOs to V2";
    }

    public String getDescription() {
        return "S3 POJOs to V2";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
            JavaType type = newClass.getType();
            if (!(type instanceof JavaType.FullyQualified)) {
                return newClass;
            }
            if (type.isAssignableFrom(COMPETE_MPU) && newClass.getArguments().size() == 4) {
                this.addV2S3ModelImport("CompleteMultipartUploadRequest");
                this.addV2S3ModelImport("CompletedMultipartUpload");
                List params = newClass.getArguments();
                String v2Builder = "CompleteMultipartUploadRequest.builder().bucket(#{any()}).key(#{any()}).uploadId(#{any()}).multipartUpload(CompletedMultipartUpload.builder().parts(#{any()}).build()).build()";
                return JavaTemplate.builder((String)v2Builder).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{params.get(0), params.get(1), params.get(2), params.get(3)});
            }
            if (type.isAssignableFrom(OBJECT_TAGGING) && newClass.getArguments().size() == 1) {
                this.addV2S3ModelImport("Tagging");
                String v2Builder = "Tagging.builder().tagSet(#{any()}).build();";
                return JavaTemplate.builder((String)v2Builder).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{newClass.getArguments().get(0)});
            }
            if (type.isAssignableFrom(GET_OBJECT_TAGGING_RESULT) && newClass.getArguments().size() == 1) {
                this.addV2S3ModelImport("GetObjectTaggingResponse");
                String v2Builder = "GetObjectTaggingResponse.builder().tagSet(#{any()}).build();";
                return JavaTemplate.builder((String)v2Builder).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{newClass.getArguments().get(0)});
            }
            return super.visitNewClass(newClass, (Object)executionContext);
        }

        private void addV2S3ModelImport(String className) {
            this.doAfterVisit((TreeVisitor)new AddImport("software.amazon.awssdk.services.s3.model." + className, null, false));
        }
    }
}

