/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.async;

import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.async.DelegatingSubscriber;

@SdkInternalApi
public class BufferingSubscriber<T>
extends DelegatingSubscriber<T, List<T>> {
    private final int bufferSize;
    private List<T> currentBuffer;

    public BufferingSubscriber(Subscriber<? super List<T>> subscriber, int bufferSize) {
        super(subscriber);
        this.bufferSize = bufferSize;
        this.currentBuffer = new ArrayList<T>(bufferSize);
    }

    public void onNext(T t) {
        this.currentBuffer.add(t);
        if (this.currentBuffer.size() == this.bufferSize) {
            this.subscriber.onNext(this.currentBuffer);
            this.currentBuffer.clear();
        }
    }

    @Override
    public void onComplete() {
        if (this.currentBuffer.size() > 0) {
            this.subscriber.onNext(this.currentBuffer);
        }
        super.onComplete();
    }
}

