/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.async;

import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.async.DelegatingSubscriber;

@SdkInternalApi
public class LimitingSubscriber<T>
extends DelegatingSubscriber<T, T> {
    private final int limit;
    private final AtomicInteger delivered = new AtomicInteger(0);
    private Subscription subscription;

    public LimitingSubscriber(Subscriber<? super T> subscriber, int limit) {
        super(subscriber);
        this.limit = limit;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        super.onSubscribe(subscription);
        this.subscription = subscription;
    }

    public void onNext(T t) {
        if (this.delivered.get() < this.limit) {
            this.subscriber.onNext(t);
        }
        if (this.delivered.incrementAndGet() >= this.limit) {
            this.subscription.cancel();
        }
    }
}

