/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.urlconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.HttpStatusFamily;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.urlconnection.UrlConnectionFactory;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.NumericUtils;

@SdkPublicApi
public final class UrlConnectionHttpClient
implements SdkHttpClient {
    private final AttributeMap options;
    private final UrlConnectionFactory connectionFactory;

    private UrlConnectionHttpClient(AttributeMap options, UrlConnectionFactory connectionFactory) {
        this.options = options;
        this.connectionFactory = connectionFactory != null ? connectionFactory : this::createDefaultConnection;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static SdkHttpClient create() {
        return new DefaultBuilder().build();
    }

    public static SdkHttpClient create(UrlConnectionFactory connectionFactory) {
        return new UrlConnectionHttpClient(AttributeMap.empty(), connectionFactory);
    }

    public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
        HttpURLConnection connection = this.createAndConfigureConnection(request);
        return new RequestCallable(connection, request);
    }

    public void close() {
    }

    private HttpURLConnection createAndConfigureConnection(HttpExecuteRequest request) {
        HttpURLConnection connection = this.connectionFactory.createConnection(request.httpRequest().getUri());
        request.httpRequest().headers().forEach((key, values) -> values.forEach(value -> connection.setRequestProperty((String)key, (String)value)));
        FunctionalUtils.invokeSafely(() -> connection.setRequestMethod(request.httpRequest().method().name()));
        if (request.contentStreamProvider().isPresent()) {
            connection.setDoOutput(true);
        }
        connection.setInstanceFollowRedirects(false);
        return connection;
    }

    private HttpURLConnection createDefaultConnection(URI uri) {
        HttpURLConnection connection = (HttpURLConnection)FunctionalUtils.invokeSafely(() -> (HttpURLConnection)uri.toURL().openConnection());
        connection.setConnectTimeout(NumericUtils.saturatedCast((long)((Duration)this.options.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).toMillis()));
        connection.setReadTimeout(NumericUtils.saturatedCast((long)((Duration)this.options.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)).toMillis()));
        return connection;
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();

        private DefaultBuilder() {
        }

        @Override
        public Builder socketTimeout(Duration socketTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)socketTimeout);
            return this;
        }

        public void setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout(socketTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration connectionTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        public SdkHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new UrlConnectionHttpClient(this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS), null);
        }
    }

    public static interface Builder
    extends SdkHttpClient.Builder<Builder> {
        public Builder socketTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);
    }

    private static class RequestCallable
    implements ExecutableHttpRequest {
        private final HttpURLConnection connection;
        private final HttpExecuteRequest request;

        private RequestCallable(HttpURLConnection connection, HttpExecuteRequest request) {
            this.connection = connection;
            this.request = request;
        }

        public HttpExecuteResponse call() throws IOException {
            this.connection.connect();
            this.request.contentStreamProvider().ifPresent(provider -> {
                Long cfr_ignored_0 = (Long)FunctionalUtils.invokeSafely(() -> IoUtils.copy((InputStream)provider.newStream(), (OutputStream)this.connection.getOutputStream()));
            });
            int responseCode = this.connection.getResponseCode();
            boolean isErrorResponse = HttpStatusFamily.of((int)responseCode).isOneOf(new HttpStatusFamily[]{HttpStatusFamily.CLIENT_ERROR, HttpStatusFamily.SERVER_ERROR});
            InputStream content = !isErrorResponse ? this.connection.getInputStream() : this.connection.getErrorStream();
            return HttpExecuteResponse.builder().response((SdkHttpResponse)SdkHttpResponse.builder().statusCode(responseCode).statusText(this.connection.getResponseMessage()).headers(this.extractHeaders(this.connection)).build()).responseBody(AbortableInputStream.create((InputStream)content)).build();
        }

        private Map<String, List<String>> extractHeaders(HttpURLConnection response) {
            return response.getHeaderFields().entrySet().stream().filter(e -> e.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public void abort() {
            this.connection.disconnect();
        }
    }
}

