/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.trustedadvisor.model.OrganizationRecommendationResourceSummary;
import software.amazon.awssdk.services.trustedadvisor.model.OrganizationRecommendationResourceSummaryListCopier;
import software.amazon.awssdk.services.trustedadvisor.model.TrustedAdvisorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationRecommendationResourcesResponse
extends TrustedAdvisorResponse
implements ToCopyableBuilder<Builder, ListOrganizationRecommendationResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOrganizationRecommendationResourcesResponse.getter(ListOrganizationRecommendationResourcesResponse::nextToken)).setter(ListOrganizationRecommendationResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<OrganizationRecommendationResourceSummary>> ORGANIZATION_RECOMMENDATION_RESOURCE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationRecommendationResourceSummaries").getter(ListOrganizationRecommendationResourcesResponse.getter(ListOrganizationRecommendationResourcesResponse::organizationRecommendationResourceSummaries)).setter(ListOrganizationRecommendationResourcesResponse.setter(Builder::organizationRecommendationResourceSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationRecommendationResourceSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationRecommendationResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ORGANIZATION_RECOMMENDATION_RESOURCE_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<OrganizationRecommendationResourceSummary> organizationRecommendationResourceSummaries;

    private ListOrganizationRecommendationResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.organizationRecommendationResourceSummaries = builder.organizationRecommendationResourceSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasOrganizationRecommendationResourceSummaries() {
        return this.organizationRecommendationResourceSummaries != null && !(this.organizationRecommendationResourceSummaries instanceof SdkAutoConstructList);
    }

    public final List<OrganizationRecommendationResourceSummary> organizationRecommendationResourceSummaries() {
        return this.organizationRecommendationResourceSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationRecommendationResourceSummaries() ? this.organizationRecommendationResourceSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationRecommendationResourcesResponse)) {
            return false;
        }
        ListOrganizationRecommendationResourcesResponse other = (ListOrganizationRecommendationResourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasOrganizationRecommendationResourceSummaries() == other.hasOrganizationRecommendationResourceSummaries() && Objects.equals(this.organizationRecommendationResourceSummaries(), other.organizationRecommendationResourceSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrganizationRecommendationResourcesResponse").add("NextToken", (Object)this.nextToken()).add("OrganizationRecommendationResourceSummaries", this.hasOrganizationRecommendationResourceSummaries() ? this.organizationRecommendationResourceSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "organizationRecommendationResourceSummaries": {
                return Optional.ofNullable(clazz.cast(this.organizationRecommendationResourceSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationRecommendationResourcesResponse, T> g) {
        return obj -> g.apply((ListOrganizationRecommendationResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TrustedAdvisorResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<OrganizationRecommendationResourceSummary> organizationRecommendationResourceSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationRecommendationResourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.organizationRecommendationResourceSummaries(model.organizationRecommendationResourceSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<OrganizationRecommendationResourceSummary.Builder> getOrganizationRecommendationResourceSummaries() {
            List<OrganizationRecommendationResourceSummary.Builder> result = OrganizationRecommendationResourceSummaryListCopier.copyToBuilder(this.organizationRecommendationResourceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationRecommendationResourceSummaries(Collection<OrganizationRecommendationResourceSummary.BuilderImpl> organizationRecommendationResourceSummaries) {
            this.organizationRecommendationResourceSummaries = OrganizationRecommendationResourceSummaryListCopier.copyFromBuilder(organizationRecommendationResourceSummaries);
        }

        @Override
        public final Builder organizationRecommendationResourceSummaries(Collection<OrganizationRecommendationResourceSummary> organizationRecommendationResourceSummaries) {
            this.organizationRecommendationResourceSummaries = OrganizationRecommendationResourceSummaryListCopier.copy(organizationRecommendationResourceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationRecommendationResourceSummaries(OrganizationRecommendationResourceSummary ... organizationRecommendationResourceSummaries) {
            this.organizationRecommendationResourceSummaries(Arrays.asList(organizationRecommendationResourceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationRecommendationResourceSummaries(Consumer<OrganizationRecommendationResourceSummary.Builder> ... organizationRecommendationResourceSummaries) {
            this.organizationRecommendationResourceSummaries(Stream.of(organizationRecommendationResourceSummaries).map(c -> (OrganizationRecommendationResourceSummary)((OrganizationRecommendationResourceSummary.Builder)OrganizationRecommendationResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOrganizationRecommendationResourcesResponse build() {
            return new ListOrganizationRecommendationResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TrustedAdvisorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationRecommendationResourcesResponse> {
        public Builder nextToken(String var1);

        public Builder organizationRecommendationResourceSummaries(Collection<OrganizationRecommendationResourceSummary> var1);

        public Builder organizationRecommendationResourceSummaries(OrganizationRecommendationResourceSummary ... var1);

        public Builder organizationRecommendationResourceSummaries(Consumer<OrganizationRecommendationResourceSummary.Builder> ... var1);
    }
}

