/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorAsyncClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.RecommendationSummary;

public class ListRecommendationsPublisher
implements SdkPublisher<ListRecommendationsResponse> {
    private final TrustedAdvisorAsyncClient client;
    private final ListRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommendationsPublisher(TrustedAdvisorAsyncClient client, ListRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommendationsPublisher(TrustedAdvisorAsyncClient client, ListRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecommendationSummary> recommendationSummaries() {
        Function<ListRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendationSummaries() != null) {
                return response.recommendationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecommendationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecommendationsResponseFetcher
    implements AsyncPageFetcher<ListRecommendationsResponse> {
        private ListRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommendationsResponse> nextPage(ListRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationsPublisher.this.client.listRecommendations(ListRecommendationsPublisher.this.firstRequest);
            }
            return ListRecommendationsPublisher.this.client.listRecommendations((ListRecommendationsRequest)((Object)ListRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

