/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportSshPublicKeyResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, ImportSshPublicKeyResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportSshPublicKeyResponse.getter(ImportSshPublicKeyResponse::serverId)).setter(ImportSshPublicKeyResponse.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportSshPublicKeyResponse.getter(ImportSshPublicKeyResponse::sshPublicKeyId)).setter(ImportSshPublicKeyResponse.setter(Builder::sshPublicKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportSshPublicKeyResponse.getter(ImportSshPublicKeyResponse::userName)).setter(ImportSshPublicKeyResponse.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, SSH_PUBLIC_KEY_ID_FIELD, USER_NAME_FIELD));
    private final String serverId;
    private final String sshPublicKeyId;
    private final String userName;

    private ImportSshPublicKeyResponse(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.sshPublicKeyId = builder.sshPublicKeyId;
        this.userName = builder.userName;
    }

    public String serverId() {
        return this.serverId;
    }

    public String sshPublicKeyId() {
        return this.sshPublicKeyId;
    }

    public String userName() {
        return this.userName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSshPublicKeyResponse)) {
            return false;
        }
        ImportSshPublicKeyResponse other = (ImportSshPublicKeyResponse)((Object)obj);
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.sshPublicKeyId(), other.sshPublicKeyId()) && Objects.equals(this.userName(), other.userName());
    }

    public String toString() {
        return ToString.builder((String)"ImportSshPublicKeyResponse").add("ServerId", (Object)this.serverId()).add("SshPublicKeyId", (Object)this.sshPublicKeyId()).add("UserName", (Object)this.userName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "SshPublicKeyId": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeyId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportSshPublicKeyResponse, T> g) {
        return obj -> g.apply((ImportSshPublicKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String serverId;
        private String sshPublicKeyId;
        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSshPublicKeyResponse model) {
            super(model);
            this.serverId(model.serverId);
            this.sshPublicKeyId(model.sshPublicKeyId);
            this.userName(model.userName);
        }

        public final String getServerId() {
            return this.serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getSshPublicKeyId() {
            return this.sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public ImportSshPublicKeyResponse build() {
            return new ImportSshPublicKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportSshPublicKeyResponse> {
        public Builder serverId(String var1);

        public Builder sshPublicKeyId(String var1);

        public Builder userName(String var1);
    }
}

