/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDirectoryListingRequest extends TransferRequest implements
        ToCopyableBuilder<StartDirectoryListingRequest.Builder, StartDirectoryListingRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(StartDirectoryListingRequest::connectorId))
            .setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()).build();

    private static final SdkField<String> REMOTE_DIRECTORY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemoteDirectoryPath").getter(getter(StartDirectoryListingRequest::remoteDirectoryPath))
            .setter(setter(Builder::remoteDirectoryPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDirectoryPath").build())
            .build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(StartDirectoryListingRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final SdkField<String> OUTPUT_DIRECTORY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputDirectoryPath").getter(getter(StartDirectoryListingRequest::outputDirectoryPath))
            .setter(setter(Builder::outputDirectoryPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDirectoryPath").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD,
            REMOTE_DIRECTORY_PATH_FIELD, MAX_ITEMS_FIELD, OUTPUT_DIRECTORY_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorId;

    private final String remoteDirectoryPath;

    private final Integer maxItems;

    private final String outputDirectoryPath;

    private StartDirectoryListingRequest(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.remoteDirectoryPath = builder.remoteDirectoryPath;
        this.maxItems = builder.maxItems;
        this.outputDirectoryPath = builder.outputDirectoryPath;
    }

    /**
     * <p>
     * The unique identifier for the connector.
     * </p>
     * 
     * @return The unique identifier for the connector.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * Specifies the directory on the remote SFTP server for which you want to list its contents.
     * </p>
     * 
     * @return Specifies the directory on the remote SFTP server for which you want to list its contents.
     */
    public final String remoteDirectoryPath() {
        return remoteDirectoryPath;
    }

    /**
     * <p>
     * An optional parameter where you can specify the maximum number of file/directory names to retrieve. The default
     * value is 1,000.
     * </p>
     * 
     * @return An optional parameter where you can specify the maximum number of file/directory names to retrieve. The
     *         default value is 1,000.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * Specifies the path (bucket and prefix) in Amazon S3 storage to store the results of the directory listing.
     * </p>
     * 
     * @return Specifies the path (bucket and prefix) in Amazon S3 storage to store the results of the directory
     *         listing.
     */
    public final String outputDirectoryPath() {
        return outputDirectoryPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDirectoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(outputDirectoryPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDirectoryListingRequest)) {
            return false;
        }
        StartDirectoryListingRequest other = (StartDirectoryListingRequest) obj;
        return Objects.equals(connectorId(), other.connectorId())
                && Objects.equals(remoteDirectoryPath(), other.remoteDirectoryPath())
                && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(outputDirectoryPath(), other.outputDirectoryPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDirectoryListingRequest").add("ConnectorId", connectorId())
                .add("RemoteDirectoryPath", remoteDirectoryPath()).add("MaxItems", maxItems())
                .add("OutputDirectoryPath", outputDirectoryPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "RemoteDirectoryPath":
            return Optional.ofNullable(clazz.cast(remoteDirectoryPath()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "OutputDirectoryPath":
            return Optional.ofNullable(clazz.cast(outputDirectoryPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("RemoteDirectoryPath", REMOTE_DIRECTORY_PATH_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("OutputDirectoryPath", OUTPUT_DIRECTORY_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDirectoryListingRequest, T> g) {
        return obj -> g.apply((StartDirectoryListingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartDirectoryListingRequest> {
        /**
         * <p>
         * The unique identifier for the connector.
         * </p>
         * 
         * @param connectorId
         *        The unique identifier for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * Specifies the directory on the remote SFTP server for which you want to list its contents.
         * </p>
         * 
         * @param remoteDirectoryPath
         *        Specifies the directory on the remote SFTP server for which you want to list its contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDirectoryPath(String remoteDirectoryPath);

        /**
         * <p>
         * An optional parameter where you can specify the maximum number of file/directory names to retrieve. The
         * default value is 1,000.
         * </p>
         * 
         * @param maxItems
         *        An optional parameter where you can specify the maximum number of file/directory names to retrieve.
         *        The default value is 1,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * Specifies the path (bucket and prefix) in Amazon S3 storage to store the results of the directory listing.
         * </p>
         * 
         * @param outputDirectoryPath
         *        Specifies the path (bucket and prefix) in Amazon S3 storage to store the results of the directory
         *        listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDirectoryPath(String outputDirectoryPath);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String connectorId;

        private String remoteDirectoryPath;

        private Integer maxItems;

        private String outputDirectoryPath;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDirectoryListingRequest model) {
            super(model);
            connectorId(model.connectorId);
            remoteDirectoryPath(model.remoteDirectoryPath);
            maxItems(model.maxItems);
            outputDirectoryPath(model.outputDirectoryPath);
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getRemoteDirectoryPath() {
            return remoteDirectoryPath;
        }

        public final void setRemoteDirectoryPath(String remoteDirectoryPath) {
            this.remoteDirectoryPath = remoteDirectoryPath;
        }

        @Override
        public final Builder remoteDirectoryPath(String remoteDirectoryPath) {
            this.remoteDirectoryPath = remoteDirectoryPath;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getOutputDirectoryPath() {
            return outputDirectoryPath;
        }

        public final void setOutputDirectoryPath(String outputDirectoryPath) {
            this.outputDirectoryPath = outputDirectoryPath;
        }

        @Override
        public final Builder outputDirectoryPath(String outputDirectoryPath) {
            this.outputDirectoryPath = outputDirectoryPath;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDirectoryListingRequest build() {
            return new StartDirectoryListingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
