/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ExecutionStepResultsCopier {
    static List<ExecutionStepResult> copy(Collection<? extends ExecutionStepResult> executionStepResultsParam) {
        List<ExecutionStepResult> list;
        if (executionStepResultsParam == null || executionStepResultsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExecutionStepResult> modifiableList = new ArrayList<>(executionStepResultsParam.size());
            executionStepResultsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ExecutionStepResult> copyFromBuilder(Collection<? extends ExecutionStepResult.Builder> executionStepResultsParam) {
        List<ExecutionStepResult> list;
        if (executionStepResultsParam == null || executionStepResultsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExecutionStepResult> modifiableList = new ArrayList<>(executionStepResultsParam.size());
            executionStepResultsParam.forEach(entry -> {
                ExecutionStepResult member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ExecutionStepResult.Builder> copyToBuilder(Collection<? extends ExecutionStepResult> executionStepResultsParam) {
        List<ExecutionStepResult.Builder> list;
        if (executionStepResultsParam == null || executionStepResultsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExecutionStepResult.Builder> modifiableList = new ArrayList<>(executionStepResultsParam.size());
            executionStepResultsParam.forEach(entry -> {
                ExecutionStepResult.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
