/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCertificateRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, UpdateCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateId").getter(UpdateCertificateRequest.getter(UpdateCertificateRequest::certificateId)).setter(UpdateCertificateRequest.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()}).build();
    private static final SdkField<Instant> ACTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActiveDate").getter(UpdateCertificateRequest.getter(UpdateCertificateRequest::activeDate)).setter(UpdateCertificateRequest.setter(Builder::activeDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDate").build()}).build();
    private static final SdkField<Instant> INACTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InactiveDate").getter(UpdateCertificateRequest.getter(UpdateCertificateRequest::inactiveDate)).setter(UpdateCertificateRequest.setter(Builder::inactiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InactiveDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateCertificateRequest.getter(UpdateCertificateRequest::description)).setter(UpdateCertificateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD, ACTIVE_DATE_FIELD, INACTIVE_DATE_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCertificateRequest.memberNameToFieldInitializer();
    private final String certificateId;
    private final Instant activeDate;
    private final Instant inactiveDate;
    private final String description;

    private UpdateCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.activeDate = builder.activeDate;
        this.inactiveDate = builder.inactiveDate;
        this.description = builder.description;
    }

    public final String certificateId() {
        return this.certificateId;
    }

    public final Instant activeDate() {
        return this.activeDate;
    }

    public final Instant inactiveDate() {
        return this.inactiveDate;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inactiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCertificateRequest)) {
            return false;
        }
        UpdateCertificateRequest other = (UpdateCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.activeDate(), other.activeDate()) && Objects.equals(this.inactiveDate(), other.inactiveDate()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCertificateRequest").add("CertificateId", (Object)this.certificateId()).add("ActiveDate", (Object)this.activeDate()).add("InactiveDate", (Object)this.inactiveDate()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "ActiveDate": {
                return Optional.ofNullable(clazz.cast(this.activeDate()));
            }
            case "InactiveDate": {
                return Optional.ofNullable(clazz.cast(this.inactiveDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CertificateId", CERTIFICATE_ID_FIELD);
        map.put("ActiveDate", ACTIVE_DATE_FIELD);
        map.put("InactiveDate", INACTIVE_DATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCertificateRequest, T> g) {
        return obj -> g.apply((UpdateCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String certificateId;
        private Instant activeDate;
        private Instant inactiveDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCertificateRequest model) {
            super(model);
            this.certificateId(model.certificateId);
            this.activeDate(model.activeDate);
            this.inactiveDate(model.inactiveDate);
            this.description(model.description);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final Instant getActiveDate() {
            return this.activeDate;
        }

        public final void setActiveDate(Instant activeDate) {
            this.activeDate = activeDate;
        }

        @Override
        public final Builder activeDate(Instant activeDate) {
            this.activeDate = activeDate;
            return this;
        }

        public final Instant getInactiveDate() {
            return this.inactiveDate;
        }

        public final void setInactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
        }

        @Override
        public final Builder inactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCertificateRequest build() {
            return new UpdateCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCertificateRequest> {
        public Builder certificateId(String var1);

        public Builder activeDate(Instant var1);

        public Builder inactiveDate(Instant var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

