/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.CertificateUsageType;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportCertificateRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, ImportCertificateRequest> {
    private static final SdkField<String> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Usage").getter(ImportCertificateRequest.getter(ImportCertificateRequest::usageAsString)).setter(ImportCertificateRequest.setter(Builder::usage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usage").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(ImportCertificateRequest.getter(ImportCertificateRequest::certificate)).setter(ImportCertificateRequest.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateChain").getter(ImportCertificateRequest.getter(ImportCertificateRequest::certificateChain)).setter(ImportCertificateRequest.setter(Builder::certificateChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()}).build();
    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateKey").getter(ImportCertificateRequest.getter(ImportCertificateRequest::privateKey)).setter(ImportCertificateRequest.setter(Builder::privateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()}).build();
    private static final SdkField<Instant> ACTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActiveDate").getter(ImportCertificateRequest.getter(ImportCertificateRequest::activeDate)).setter(ImportCertificateRequest.setter(Builder::activeDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDate").build()}).build();
    private static final SdkField<Instant> INACTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InactiveDate").getter(ImportCertificateRequest.getter(ImportCertificateRequest::inactiveDate)).setter(ImportCertificateRequest.setter(Builder::inactiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InactiveDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ImportCertificateRequest.getter(ImportCertificateRequest::description)).setter(ImportCertificateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ImportCertificateRequest.getter(ImportCertificateRequest::tags)).setter(ImportCertificateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_FIELD, CERTIFICATE_FIELD, CERTIFICATE_CHAIN_FIELD, PRIVATE_KEY_FIELD, ACTIVE_DATE_FIELD, INACTIVE_DATE_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Usage", USAGE_FIELD);
            this.put("Certificate", CERTIFICATE_FIELD);
            this.put("CertificateChain", CERTIFICATE_CHAIN_FIELD);
            this.put("PrivateKey", PRIVATE_KEY_FIELD);
            this.put("ActiveDate", ACTIVE_DATE_FIELD);
            this.put("InactiveDate", INACTIVE_DATE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String usage;
    private final String certificate;
    private final String certificateChain;
    private final String privateKey;
    private final Instant activeDate;
    private final Instant inactiveDate;
    private final String description;
    private final List<Tag> tags;

    private ImportCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.usage = builder.usage;
        this.certificate = builder.certificate;
        this.certificateChain = builder.certificateChain;
        this.privateKey = builder.privateKey;
        this.activeDate = builder.activeDate;
        this.inactiveDate = builder.inactiveDate;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final CertificateUsageType usage() {
        return CertificateUsageType.fromValue(this.usage);
    }

    public final String usageAsString() {
        return this.usage;
    }

    public final String certificate() {
        return this.certificate;
    }

    public final String certificateChain() {
        return this.certificateChain;
    }

    public final String privateKey() {
        return this.privateKey;
    }

    public final Instant activeDate() {
        return this.activeDate;
    }

    public final Instant inactiveDate() {
        return this.inactiveDate;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.usageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inactiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCertificateRequest)) {
            return false;
        }
        ImportCertificateRequest other = (ImportCertificateRequest)((Object)obj);
        return Objects.equals(this.usageAsString(), other.usageAsString()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.certificateChain(), other.certificateChain()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.activeDate(), other.activeDate()) && Objects.equals(this.inactiveDate(), other.inactiveDate()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ImportCertificateRequest").add("Usage", (Object)this.usageAsString()).add("Certificate", (Object)(this.certificate() == null ? null : "*** Sensitive Data Redacted ***")).add("CertificateChain", (Object)(this.certificateChain() == null ? null : "*** Sensitive Data Redacted ***")).add("PrivateKey", (Object)(this.privateKey() == null ? null : "*** Sensitive Data Redacted ***")).add("ActiveDate", (Object)this.activeDate()).add("InactiveDate", (Object)this.inactiveDate()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Usage": {
                return Optional.ofNullable(clazz.cast(this.usageAsString()));
            }
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "CertificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
            case "PrivateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
            case "ActiveDate": {
                return Optional.ofNullable(clazz.cast(this.activeDate()));
            }
            case "InactiveDate": {
                return Optional.ofNullable(clazz.cast(this.inactiveDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportCertificateRequest, T> g) {
        return obj -> g.apply((ImportCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String usage;
        private String certificate;
        private String certificateChain;
        private String privateKey;
        private Instant activeDate;
        private Instant inactiveDate;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCertificateRequest model) {
            super(model);
            this.usage(model.usage);
            this.certificate(model.certificate);
            this.certificateChain(model.certificateChain);
            this.privateKey(model.privateKey);
            this.activeDate(model.activeDate);
            this.inactiveDate(model.inactiveDate);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getUsage() {
            return this.usage;
        }

        public final void setUsage(String usage) {
            this.usage = usage;
        }

        @Override
        public final Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public final Builder usage(CertificateUsageType usage) {
            this.usage(usage == null ? null : usage.toString());
            return this;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getCertificateChain() {
            return this.certificateChain;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final Instant getActiveDate() {
            return this.activeDate;
        }

        public final void setActiveDate(Instant activeDate) {
            this.activeDate = activeDate;
        }

        @Override
        public final Builder activeDate(Instant activeDate) {
            this.activeDate = activeDate;
            return this;
        }

        public final Instant getInactiveDate() {
            return this.inactiveDate;
        }

        public final void setInactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
        }

        @Override
        public final Builder inactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportCertificateRequest build() {
            return new ImportCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportCertificateRequest> {
        public Builder usage(String var1);

        public Builder usage(CertificateUsageType var1);

        public Builder certificate(String var1);

        public Builder certificateChain(String var1);

        public Builder privateKey(String var1);

        public Builder activeDate(Instant var1);

        public Builder inactiveDate(Instant var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

