/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferAsyncClient;
import software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest;
import software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse;

public class ListSecurityPoliciesPublisher
implements SdkPublisher<ListSecurityPoliciesResponse> {
    private final TransferAsyncClient client;
    private final ListSecurityPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityPoliciesPublisher(TransferAsyncClient client, ListSecurityPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityPoliciesPublisher(TransferAsyncClient client, ListSecurityPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> securityPolicyNames() {
        Function<ListSecurityPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityPolicyNames() != null) {
                return response.securityPolicyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityPoliciesResponseFetcher
    implements AsyncPageFetcher<ListSecurityPoliciesResponse> {
        private ListSecurityPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityPoliciesResponse> nextPage(ListSecurityPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityPoliciesPublisher.this.client.listSecurityPolicies(ListSecurityPoliciesPublisher.this.firstRequest);
            }
            return ListSecurityPoliciesPublisher.this.client.listSecurityPolicies((ListSecurityPoliciesRequest)((Object)ListSecurityPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

