/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.model.ListAccessesRequest;
import software.amazon.awssdk.services.transfer.model.ListAccessesResponse;

public class ListAccessesIterable
implements SdkIterable<ListAccessesResponse> {
    private final TransferClient client;
    private final ListAccessesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessesIterable(TransferClient client, ListAccessesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccessesResponseFetcher();
    }

    public Iterator<ListAccessesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAccessesResponseFetcher
    implements SyncPageFetcher<ListAccessesResponse> {
        private ListAccessesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessesResponse nextPage(ListAccessesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessesIterable.this.client.listAccesses(ListAccessesIterable.this.firstRequest);
            }
            return ListAccessesIterable.this.client.listAccesses((ListAccessesRequest)((Object)ListAccessesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

