/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<DimensionMapping.Builder, DimensionMapping> {
    private static final SdkField<String> SOURCE_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceColumn").getter(getter(DimensionMapping::sourceColumn)).setter(setter(Builder::sourceColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceColumn").build()).build();

    private static final SdkField<String> DESTINATION_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationColumn").getter(getter(DimensionMapping::destinationColumn))
            .setter(setter(Builder::destinationColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationColumn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_COLUMN_FIELD,
            DESTINATION_COLUMN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceColumn;

    private final String destinationColumn;

    private DimensionMapping(BuilderImpl builder) {
        this.sourceColumn = builder.sourceColumn;
        this.destinationColumn = builder.destinationColumn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String sourceColumn() {
        return sourceColumn;
    }

    /**
     * <p>
     * </p>
     * 
     * @return
     */
    public final String destinationColumn() {
        return destinationColumn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceColumn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationColumn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionMapping)) {
            return false;
        }
        DimensionMapping other = (DimensionMapping) obj;
        return Objects.equals(sourceColumn(), other.sourceColumn())
                && Objects.equals(destinationColumn(), other.destinationColumn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionMapping").add("SourceColumn", sourceColumn())
                .add("DestinationColumn", destinationColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceColumn":
            return Optional.ofNullable(clazz.cast(sourceColumn()));
        case "DestinationColumn":
            return Optional.ofNullable(clazz.cast(destinationColumn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceColumn", SOURCE_COLUMN_FIELD);
        map.put("DestinationColumn", DESTINATION_COLUMN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DimensionMapping, T> g) {
        return obj -> g.apply((DimensionMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionMapping> {
        /**
         * <p/>
         * 
         * @param sourceColumn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceColumn(String sourceColumn);

        /**
         * <p>
         * </p>
         * 
         * @param destinationColumn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationColumn(String destinationColumn);
    }

    static final class BuilderImpl implements Builder {
        private String sourceColumn;

        private String destinationColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionMapping model) {
            sourceColumn(model.sourceColumn);
            destinationColumn(model.destinationColumn);
        }

        public final String getSourceColumn() {
            return sourceColumn;
        }

        public final void setSourceColumn(String sourceColumn) {
            this.sourceColumn = sourceColumn;
        }

        @Override
        public final Builder sourceColumn(String sourceColumn) {
            this.sourceColumn = sourceColumn;
            return this;
        }

        public final String getDestinationColumn() {
            return destinationColumn;
        }

        public final void setDestinationColumn(String destinationColumn) {
            this.destinationColumn = destinationColumn;
        }

        @Override
        public final Builder destinationColumn(String destinationColumn) {
            this.destinationColumn = destinationColumn;
            return this;
        }

        @Override
        public DimensionMapping build() {
            return new DimensionMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
