/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteAsyncClient;
import software.amazon.awssdk.services.timestreamwrite.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse;

public class ListDatabasesPublisher
implements SdkPublisher<ListDatabasesResponse> {
    private final TimestreamWriteAsyncClient client;
    private final ListDatabasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatabasesPublisher(TimestreamWriteAsyncClient client, ListDatabasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatabasesPublisher(TimestreamWriteAsyncClient client, ListDatabasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatabasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatabasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDatabasesResponseFetcher
    implements AsyncPageFetcher<ListDatabasesResponse> {
        private ListDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(ListDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatabasesResponse> nextPage(ListDatabasesResponse previousPage) {
            if (previousPage == null) {
                return ListDatabasesPublisher.this.client.listDatabases(ListDatabasesPublisher.this.firstRequest);
            }
            return ListDatabasesPublisher.this.client.listDatabases((ListDatabasesRequest)((Object)ListDatabasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

