/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteEndpointDiscoveryCacheLoader;
import software.amazon.awssdk.services.timestreamwrite.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamwrite.model.ConflictException;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.InternalServerException;
import software.amazon.awssdk.services.timestreamwrite.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.RejectedRecordsException;
import software.amazon.awssdk.services.timestreamwrite.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamwrite.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamwrite.model.TagResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.TagResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteException;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UntagResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UntagResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ValidationException;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse;
import software.amazon.awssdk.services.timestreamwrite.paginators.ListDatabasesIterable;
import software.amazon.awssdk.services.timestreamwrite.paginators.ListTablesIterable;
import software.amazon.awssdk.services.timestreamwrite.transform.CreateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DeleteDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DescribeDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DescribeTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ListDatabasesRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.UpdateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.WriteRecordsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultTimestreamWriteClient
implements TimestreamWriteClient {
    private static final Logger log = Logger.loggerFor(DefaultTimestreamWriteClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private EndpointDiscoveryRefreshCache endpointDiscoveryCache;

    protected DefaultTimestreamWriteClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        if (((Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)).booleanValue()) {
            this.endpointDiscoveryCache = EndpointDiscoveryRefreshCache.create((EndpointDiscoveryCacheLoader)TimestreamWriteEndpointDiscoveryCacheLoader.create(this));
            if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE) {
                log.warn(() -> "Endpoint discovery is enabled for this client, and an endpoint override was also specified. This will disable endpoint discovery for methods that require it, instead using the specified endpoint override. This may or may not be what you intended.");
            }
        }
    }

    public final String serviceName() {
        return "timestream";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatabaseResponse createDatabase(CreateDatabaseRequest createDatabaseRequest) throws ConflictException, ValidationException, AccessDeniedException, ServiceQuotaExceededException, ThrottlingException, InvalidEndpointException, InternalServerException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatabaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = createDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createDatabaseRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, createDatabaseRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatabase");
            CreateDatabaseResponse createDatabaseResponse = (CreateDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatabase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$createDatabase$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, InvalidEndpointException, InternalServerException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = createTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, createTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTable");
            CreateTableResponse createTableResponse = (CreateTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$createTable$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatabaseResponse deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatabaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = deleteDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteDatabaseRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, deleteDatabaseRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatabase");
            DeleteDatabaseResponse deleteDatabaseResponse = (DeleteDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatabase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$deleteDatabase$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = deleteTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, deleteTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTable");
            DeleteTableResponse deleteTableResponse = (DeleteTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$deleteTable$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatabaseResponse describeDatabase(DescribeDatabaseRequest describeDatabaseRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatabaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeDatabaseRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, describeDatabaseRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDatabase");
            DescribeDatabaseResponse describeDatabaseResponse = (DescribeDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatabase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$describeDatabase$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamWriteException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            DescribeEndpointsResponse describeEndpointsResponse = (DescribeEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$describeEndpoints$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTableResponse describeTable(DescribeTableRequest describeTableRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, describeTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTable");
            DescribeTableResponse describeTableResponse = (DescribeTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$describeTable$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatabasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = listDatabasesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listDatabasesRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, listDatabasesRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatabases");
            ListDatabasesResponse listDatabasesResponse = (ListDatabasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatabases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listDatabasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatabasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$listDatabases$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDatabasesIterable listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return new ListDatabasesIterable(this, this.applyPaginatorUserAgent(listDatabasesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTablesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = listTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTablesRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, listTablesRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTables");
            ListTablesResponse listTablesResponse = (ListTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTables").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$listTables$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return new ListTablesIterable(this, this.applyPaginatorUserAgent(listTablesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = listTagsForResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTagsForResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$listTagsForResource$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = tagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)tagResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$tagResource$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = untagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)untagResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$untagResource$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDatabaseResponse updateDatabase(UpdateDatabaseRequest updateDatabaseRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatabaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = updateDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateDatabaseRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, updateDatabaseRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDatabase");
            UpdateDatabaseResponse updateDatabaseResponse = (UpdateDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatabase").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateDatabaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$updateDatabase$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableResponse updateTable(UpdateTableRequest updateTableRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = updateTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, updateTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTable");
            UpdateTableResponse updateTableResponse = (UpdateTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$updateTable$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteRecordsResponse writeRecords(WriteRecordsRequest writeRecordsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RejectedRecordsException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, WriteRecordsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = writeRecordsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)writeRecordsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamWriteClient.resolveMetricPublishers(this.clientConfiguration, writeRecordsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"WriteRecords");
            WriteRecordsResponse writeRecordsResponse = (WriteRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("WriteRecords").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)writeRecordsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new WriteRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return writeRecordsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteClient.lambda$writeRecords$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TimestreamWriteException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEndpointException").exceptionBuilderSupplier(InvalidEndpointException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RejectedRecordsException").exceptionBuilderSupplier(RejectedRecordsException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends TimestreamWriteRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.18.5").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((TimestreamWriteRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$writeRecords$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTable$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDatabase$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTables$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatabases$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTable$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDatabase$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTable$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatabase$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTable$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatabase$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

