/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Configuration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Configuration> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(S3Configuration.getter(S3Configuration::bucketName)).setter(S3Configuration.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> OBJECT_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectKeyPrefix").getter(S3Configuration.getter(S3Configuration::objectKeyPrefix)).setter(S3Configuration.setter(Builder::objectKeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKeyPrefix").build()}).build();
    private static final SdkField<String> ENCRYPTION_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionOption").getter(S3Configuration.getter(S3Configuration::encryptionOptionAsString)).setter(S3Configuration.setter(Builder::encryptionOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionOption").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(S3Configuration.getter(S3Configuration::kmsKeyId)).setter(S3Configuration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, OBJECT_KEY_PREFIX_FIELD, ENCRYPTION_OPTION_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String objectKeyPrefix;
    private final String encryptionOption;
    private final String kmsKeyId;

    private S3Configuration(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.objectKeyPrefix = builder.objectKeyPrefix;
        this.encryptionOption = builder.encryptionOption;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String objectKeyPrefix() {
        return this.objectKeyPrefix;
    }

    public final S3EncryptionOption encryptionOption() {
        return S3EncryptionOption.fromValue(this.encryptionOption);
    }

    public final String encryptionOptionAsString() {
        return this.encryptionOption;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectKeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Configuration)) {
            return false;
        }
        S3Configuration other = (S3Configuration)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.objectKeyPrefix(), other.objectKeyPrefix()) && Objects.equals(this.encryptionOptionAsString(), other.encryptionOptionAsString()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"S3Configuration").add("BucketName", (Object)this.bucketName()).add("ObjectKeyPrefix", (Object)this.objectKeyPrefix()).add("EncryptionOption", (Object)this.encryptionOptionAsString()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "ObjectKeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.objectKeyPrefix()));
            }
            case "EncryptionOption": {
                return Optional.ofNullable(clazz.cast(this.encryptionOptionAsString()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Configuration, T> g) {
        return obj -> g.apply((S3Configuration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String objectKeyPrefix;
        private String encryptionOption;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Configuration model) {
            this.bucketName(model.bucketName);
            this.objectKeyPrefix(model.objectKeyPrefix);
            this.encryptionOption(model.encryptionOption);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getObjectKeyPrefix() {
            return this.objectKeyPrefix;
        }

        public final void setObjectKeyPrefix(String objectKeyPrefix) {
            this.objectKeyPrefix = objectKeyPrefix;
        }

        @Override
        @Transient
        public final Builder objectKeyPrefix(String objectKeyPrefix) {
            this.objectKeyPrefix = objectKeyPrefix;
            return this;
        }

        public final String getEncryptionOption() {
            return this.encryptionOption;
        }

        public final void setEncryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
        }

        @Override
        @Transient
        public final Builder encryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
            return this;
        }

        @Override
        @Transient
        public final Builder encryptionOption(S3EncryptionOption encryptionOption) {
            this.encryptionOption(encryptionOption == null ? null : encryptionOption.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public S3Configuration build() {
            return new S3Configuration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Configuration> {
        public Builder bucketName(String var1);

        public Builder objectKeyPrefix(String var1);

        public Builder encryptionOption(String var1);

        public Builder encryptionOption(S3EncryptionOption var1);

        public Builder kmsKeyId(String var1);
    }
}

