/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse;

public class ListDatabasesIterable
implements SdkIterable<ListDatabasesResponse> {
    private final TimestreamWriteClient client;
    private final ListDatabasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatabasesIterable(TimestreamWriteClient client, ListDatabasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDatabasesResponseFetcher();
    }

    public Iterator<ListDatabasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDatabasesResponseFetcher
    implements SyncPageFetcher<ListDatabasesResponse> {
        private ListDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(ListDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatabasesResponse nextPage(ListDatabasesResponse previousPage) {
            if (previousPage == null) {
                return ListDatabasesIterable.this.client.listDatabases(ListDatabasesIterable.this.firstRequest);
            }
            return ListDatabasesIterable.this.client.listDatabases((ListDatabasesRequest)((Object)ListDatabasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

