/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamquery.model.QueryComputeRequest;
import software.amazon.awssdk.services.timestreamquery.model.QueryPricingModel;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccountSettingsRequest
extends TimestreamQueryRequest
implements ToCopyableBuilder<Builder, UpdateAccountSettingsRequest> {
    private static final SdkField<Integer> MAX_QUERY_TCU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxQueryTCU").getter(UpdateAccountSettingsRequest.getter(UpdateAccountSettingsRequest::maxQueryTCU)).setter(UpdateAccountSettingsRequest.setter(Builder::maxQueryTCU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxQueryTCU").build()}).build();
    private static final SdkField<String> QUERY_PRICING_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryPricingModel").getter(UpdateAccountSettingsRequest.getter(UpdateAccountSettingsRequest::queryPricingModelAsString)).setter(UpdateAccountSettingsRequest.setter(Builder::queryPricingModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryPricingModel").build()}).build();
    private static final SdkField<QueryComputeRequest> QUERY_COMPUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryCompute").getter(UpdateAccountSettingsRequest.getter(UpdateAccountSettingsRequest::queryCompute)).setter(UpdateAccountSettingsRequest.setter(Builder::queryCompute)).constructor(QueryComputeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryCompute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_QUERY_TCU_FIELD, QUERY_PRICING_MODEL_FIELD, QUERY_COMPUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAccountSettingsRequest.memberNameToFieldInitializer();
    private final Integer maxQueryTCU;
    private final String queryPricingModel;
    private final QueryComputeRequest queryCompute;

    private UpdateAccountSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.maxQueryTCU = builder.maxQueryTCU;
        this.queryPricingModel = builder.queryPricingModel;
        this.queryCompute = builder.queryCompute;
    }

    public final Integer maxQueryTCU() {
        return this.maxQueryTCU;
    }

    public final QueryPricingModel queryPricingModel() {
        return QueryPricingModel.fromValue(this.queryPricingModel);
    }

    public final String queryPricingModelAsString() {
        return this.queryPricingModel;
    }

    public final QueryComputeRequest queryCompute() {
        return this.queryCompute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxQueryTCU());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryPricingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryCompute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsRequest)) {
            return false;
        }
        UpdateAccountSettingsRequest other = (UpdateAccountSettingsRequest)((Object)obj);
        return Objects.equals(this.maxQueryTCU(), other.maxQueryTCU()) && Objects.equals(this.queryPricingModelAsString(), other.queryPricingModelAsString()) && Objects.equals(this.queryCompute(), other.queryCompute());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAccountSettingsRequest").add("MaxQueryTCU", (Object)this.maxQueryTCU()).add("QueryPricingModel", (Object)this.queryPricingModelAsString()).add("QueryCompute", (Object)this.queryCompute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxQueryTCU": {
                return Optional.ofNullable(clazz.cast(this.maxQueryTCU()));
            }
            case "QueryPricingModel": {
                return Optional.ofNullable(clazz.cast(this.queryPricingModelAsString()));
            }
            case "QueryCompute": {
                return Optional.ofNullable(clazz.cast(this.queryCompute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaxQueryTCU", MAX_QUERY_TCU_FIELD);
        map.put("QueryPricingModel", QUERY_PRICING_MODEL_FIELD);
        map.put("QueryCompute", QUERY_COMPUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsRequest, T> g) {
        return obj -> g.apply((UpdateAccountSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamQueryRequest.BuilderImpl
    implements Builder {
        private Integer maxQueryTCU;
        private String queryPricingModel;
        private QueryComputeRequest queryCompute;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsRequest model) {
            super(model);
            this.maxQueryTCU(model.maxQueryTCU);
            this.queryPricingModel(model.queryPricingModel);
            this.queryCompute(model.queryCompute);
        }

        public final Integer getMaxQueryTCU() {
            return this.maxQueryTCU;
        }

        public final void setMaxQueryTCU(Integer maxQueryTCU) {
            this.maxQueryTCU = maxQueryTCU;
        }

        @Override
        public final Builder maxQueryTCU(Integer maxQueryTCU) {
            this.maxQueryTCU = maxQueryTCU;
            return this;
        }

        public final String getQueryPricingModel() {
            return this.queryPricingModel;
        }

        public final void setQueryPricingModel(String queryPricingModel) {
            this.queryPricingModel = queryPricingModel;
        }

        @Override
        public final Builder queryPricingModel(String queryPricingModel) {
            this.queryPricingModel = queryPricingModel;
            return this;
        }

        @Override
        public final Builder queryPricingModel(QueryPricingModel queryPricingModel) {
            this.queryPricingModel(queryPricingModel == null ? null : queryPricingModel.toString());
            return this;
        }

        public final QueryComputeRequest.Builder getQueryCompute() {
            return this.queryCompute != null ? this.queryCompute.toBuilder() : null;
        }

        public final void setQueryCompute(QueryComputeRequest.BuilderImpl queryCompute) {
            this.queryCompute = queryCompute != null ? queryCompute.build() : null;
        }

        @Override
        public final Builder queryCompute(QueryComputeRequest queryCompute) {
            this.queryCompute = queryCompute;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountSettingsRequest build() {
            return new UpdateAccountSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TimestreamQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccountSettingsRequest> {
        public Builder maxQueryTCU(Integer var1);

        public Builder queryPricingModel(String var1);

        public Builder queryPricingModel(QueryPricingModel var1);

        public Builder queryCompute(QueryComputeRequest var1);

        default public Builder queryCompute(Consumer<QueryComputeRequest.Builder> queryCompute) {
            return this.queryCompute((QueryComputeRequest)((QueryComputeRequest.Builder)QueryComputeRequest.builder().applyMutation(queryCompute)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

