/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScheduledQueryRequest
extends TimestreamQueryRequest
implements ToCopyableBuilder<Builder, DescribeScheduledQueryRequest> {
    private static final SdkField<String> SCHEDULED_QUERY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledQueryArn").getter(DescribeScheduledQueryRequest.getter(DescribeScheduledQueryRequest::scheduledQueryArn)).setter(DescribeScheduledQueryRequest.setter(Builder::scheduledQueryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledQueryArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_QUERY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeScheduledQueryRequest.memberNameToFieldInitializer();
    private final String scheduledQueryArn;

    private DescribeScheduledQueryRequest(BuilderImpl builder) {
        super(builder);
        this.scheduledQueryArn = builder.scheduledQueryArn;
    }

    public final String scheduledQueryArn() {
        return this.scheduledQueryArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledQueryArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledQueryRequest)) {
            return false;
        }
        DescribeScheduledQueryRequest other = (DescribeScheduledQueryRequest)((Object)obj);
        return Objects.equals(this.scheduledQueryArn(), other.scheduledQueryArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScheduledQueryRequest").add("ScheduledQueryArn", (Object)this.scheduledQueryArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledQueryArn": {
                return Optional.ofNullable(clazz.cast(this.scheduledQueryArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ScheduledQueryArn", SCHEDULED_QUERY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledQueryRequest, T> g) {
        return obj -> g.apply((DescribeScheduledQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamQueryRequest.BuilderImpl
    implements Builder {
        private String scheduledQueryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledQueryRequest model) {
            super(model);
            this.scheduledQueryArn(model.scheduledQueryArn);
        }

        public final String getScheduledQueryArn() {
            return this.scheduledQueryArn;
        }

        public final void setScheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
        }

        @Override
        public final Builder scheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledQueryRequest build() {
            return new DescribeScheduledQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TimestreamQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScheduledQueryRequest> {
        public Builder scheduledQueryArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

