/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryStatus> {
    private static final SdkField<Double> PROGRESS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ProgressPercentage").getter(QueryStatus.getter(QueryStatus::progressPercentage)).setter(QueryStatus.setter(Builder::progressPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercentage").build()}).build();
    private static final SdkField<Long> CUMULATIVE_BYTES_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CumulativeBytesScanned").getter(QueryStatus.getter(QueryStatus::cumulativeBytesScanned)).setter(QueryStatus.setter(Builder::cumulativeBytesScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CumulativeBytesScanned").build()}).build();
    private static final SdkField<Long> CUMULATIVE_BYTES_METERED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CumulativeBytesMetered").getter(QueryStatus.getter(QueryStatus::cumulativeBytesMetered)).setter(QueryStatus.setter(Builder::cumulativeBytesMetered)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CumulativeBytesMetered").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_PERCENTAGE_FIELD, CUMULATIVE_BYTES_SCANNED_FIELD, CUMULATIVE_BYTES_METERED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double progressPercentage;
    private final Long cumulativeBytesScanned;
    private final Long cumulativeBytesMetered;

    private QueryStatus(BuilderImpl builder) {
        this.progressPercentage = builder.progressPercentage;
        this.cumulativeBytesScanned = builder.cumulativeBytesScanned;
        this.cumulativeBytesMetered = builder.cumulativeBytesMetered;
    }

    public final Double progressPercentage() {
        return this.progressPercentage;
    }

    public final Long cumulativeBytesScanned() {
        return this.cumulativeBytesScanned;
    }

    public final Long cumulativeBytesMetered() {
        return this.cumulativeBytesMetered;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.cumulativeBytesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(this.cumulativeBytesMetered());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStatus)) {
            return false;
        }
        QueryStatus other = (QueryStatus)obj;
        return Objects.equals(this.progressPercentage(), other.progressPercentage()) && Objects.equals(this.cumulativeBytesScanned(), other.cumulativeBytesScanned()) && Objects.equals(this.cumulativeBytesMetered(), other.cumulativeBytesMetered());
    }

    public final String toString() {
        return ToString.builder((String)"QueryStatus").add("ProgressPercentage", (Object)this.progressPercentage()).add("CumulativeBytesScanned", (Object)this.cumulativeBytesScanned()).add("CumulativeBytesMetered", (Object)this.cumulativeBytesMetered()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressPercentage": {
                return Optional.ofNullable(clazz.cast(this.progressPercentage()));
            }
            case "CumulativeBytesScanned": {
                return Optional.ofNullable(clazz.cast(this.cumulativeBytesScanned()));
            }
            case "CumulativeBytesMetered": {
                return Optional.ofNullable(clazz.cast(this.cumulativeBytesMetered()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryStatus, T> g) {
        return obj -> g.apply((QueryStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double progressPercentage;
        private Long cumulativeBytesScanned;
        private Long cumulativeBytesMetered;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStatus model) {
            this.progressPercentage(model.progressPercentage);
            this.cumulativeBytesScanned(model.cumulativeBytesScanned);
            this.cumulativeBytesMetered(model.cumulativeBytesMetered);
        }

        public final Double getProgressPercentage() {
            return this.progressPercentage;
        }

        public final void setProgressPercentage(Double progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        @Override
        public final Builder progressPercentage(Double progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public final Long getCumulativeBytesScanned() {
            return this.cumulativeBytesScanned;
        }

        public final void setCumulativeBytesScanned(Long cumulativeBytesScanned) {
            this.cumulativeBytesScanned = cumulativeBytesScanned;
        }

        @Override
        public final Builder cumulativeBytesScanned(Long cumulativeBytesScanned) {
            this.cumulativeBytesScanned = cumulativeBytesScanned;
            return this;
        }

        public final Long getCumulativeBytesMetered() {
            return this.cumulativeBytesMetered;
        }

        public final void setCumulativeBytesMetered(Long cumulativeBytesMetered) {
            this.cumulativeBytesMetered = cumulativeBytesMetered;
        }

        @Override
        public final Builder cumulativeBytesMetered(Long cumulativeBytesMetered) {
            this.cumulativeBytesMetered = cumulativeBytesMetered;
            return this;
        }

        public QueryStatus build() {
            return new QueryStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryStatus> {
        public Builder progressPercentage(Double var1);

        public Builder cumulativeBytesScanned(Long var1);

        public Builder cumulativeBytesMetered(Long var1);
    }
}

