/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure that describes scheduled query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledQueryDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledQueryDescription.Builder, ScheduledQueryDescription> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ScheduledQueryDescription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ScheduledQueryDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(ScheduledQueryDescription::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ScheduledQueryDescription::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ScheduledQueryDescription::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> PREVIOUS_INVOCATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("PreviousInvocationTime").getter(getter(ScheduledQueryDescription::previousInvocationTime))
            .setter(setter(Builder::previousInvocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousInvocationTime").build())
            .build();

    private static final SdkField<Instant> NEXT_INVOCATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NextInvocationTime").getter(getter(ScheduledQueryDescription::nextInvocationTime))
            .setter(setter(Builder::nextInvocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocationTime").build())
            .build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfiguration")
            .getter(getter(ScheduledQueryDescription::scheduleConfiguration)).setter(setter(Builder::scheduleConfiguration))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build())
            .build();

    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<NotificationConfiguration> builder(MarshallingType.SDK_POJO).memberName("NotificationConfiguration")
            .getter(getter(ScheduledQueryDescription::notificationConfiguration))
            .setter(setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build())
            .build();

    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField
            .<TargetConfiguration> builder(MarshallingType.SDK_POJO).memberName("TargetConfiguration")
            .getter(getter(ScheduledQueryDescription::targetConfiguration)).setter(setter(Builder::targetConfiguration))
            .constructor(TargetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build())
            .build();

    private static final SdkField<String> SCHEDULED_QUERY_EXECUTION_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ScheduledQueryExecutionRoleArn")
            .getter(getter(ScheduledQueryDescription::scheduledQueryExecutionRoleArn))
            .setter(setter(Builder::scheduledQueryExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledQueryExecutionRoleArn")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ScheduledQueryDescription::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<ErrorReportConfiguration> ERROR_REPORT_CONFIGURATION_FIELD = SdkField
            .<ErrorReportConfiguration> builder(MarshallingType.SDK_POJO).memberName("ErrorReportConfiguration")
            .getter(getter(ScheduledQueryDescription::errorReportConfiguration))
            .setter(setter(Builder::errorReportConfiguration)).constructor(ErrorReportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReportConfiguration").build())
            .build();

    private static final SdkField<ScheduledQueryRunSummary> LAST_RUN_SUMMARY_FIELD = SdkField
            .<ScheduledQueryRunSummary> builder(MarshallingType.SDK_POJO).memberName("LastRunSummary")
            .getter(getter(ScheduledQueryDescription::lastRunSummary)).setter(setter(Builder::lastRunSummary))
            .constructor(ScheduledQueryRunSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunSummary").build()).build();

    private static final SdkField<List<ScheduledQueryRunSummary>> RECENTLY_FAILED_RUNS_FIELD = SdkField
            .<List<ScheduledQueryRunSummary>> builder(MarshallingType.LIST)
            .memberName("RecentlyFailedRuns")
            .getter(getter(ScheduledQueryDescription::recentlyFailedRuns))
            .setter(setter(Builder::recentlyFailedRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecentlyFailedRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledQueryRunSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledQueryRunSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            QUERY_STRING_FIELD, CREATION_TIME_FIELD, STATE_FIELD, PREVIOUS_INVOCATION_TIME_FIELD, NEXT_INVOCATION_TIME_FIELD,
            SCHEDULE_CONFIGURATION_FIELD, NOTIFICATION_CONFIGURATION_FIELD, TARGET_CONFIGURATION_FIELD,
            SCHEDULED_QUERY_EXECUTION_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, ERROR_REPORT_CONFIGURATION_FIELD, LAST_RUN_SUMMARY_FIELD,
            RECENTLY_FAILED_RUNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String queryString;

    private final Instant creationTime;

    private final String state;

    private final Instant previousInvocationTime;

    private final Instant nextInvocationTime;

    private final ScheduleConfiguration scheduleConfiguration;

    private final NotificationConfiguration notificationConfiguration;

    private final TargetConfiguration targetConfiguration;

    private final String scheduledQueryExecutionRoleArn;

    private final String kmsKeyId;

    private final ErrorReportConfiguration errorReportConfiguration;

    private final ScheduledQueryRunSummary lastRunSummary;

    private final List<ScheduledQueryRunSummary> recentlyFailedRuns;

    private ScheduledQueryDescription(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.queryString = builder.queryString;
        this.creationTime = builder.creationTime;
        this.state = builder.state;
        this.previousInvocationTime = builder.previousInvocationTime;
        this.nextInvocationTime = builder.nextInvocationTime;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.targetConfiguration = builder.targetConfiguration;
        this.scheduledQueryExecutionRoleArn = builder.scheduledQueryExecutionRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.errorReportConfiguration = builder.errorReportConfiguration;
        this.lastRunSummary = builder.lastRunSummary;
        this.recentlyFailedRuns = builder.recentlyFailedRuns;
    }

    /**
     * <p>
     * Scheduled query ARN.
     * </p>
     * 
     * @return Scheduled query ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Name of the scheduled query.
     * </p>
     * 
     * @return Name of the scheduled query.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The query to be run.
     * </p>
     * 
     * @return The query to be run.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * Creation time of the scheduled query.
     * </p>
     * 
     * @return Creation time of the scheduled query.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * State of the scheduled query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the scheduled query.
     * @see ScheduledQueryState
     */
    public final ScheduledQueryState state() {
        return ScheduledQueryState.fromValue(state);
    }

    /**
     * <p>
     * State of the scheduled query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the scheduled query.
     * @see ScheduledQueryState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Last time the query was run.
     * </p>
     * 
     * @return Last time the query was run.
     */
    public final Instant previousInvocationTime() {
        return previousInvocationTime;
    }

    /**
     * <p>
     * The next time the scheduled query is scheduled to run.
     * </p>
     * 
     * @return The next time the scheduled query is scheduled to run.
     */
    public final Instant nextInvocationTime() {
        return nextInvocationTime;
    }

    /**
     * <p>
     * Schedule configuration.
     * </p>
     * 
     * @return Schedule configuration.
     */
    public final ScheduleConfiguration scheduleConfiguration() {
        return scheduleConfiguration;
    }

    /**
     * <p>
     * Notification configuration.
     * </p>
     * 
     * @return Notification configuration.
     */
    public final NotificationConfiguration notificationConfiguration() {
        return notificationConfiguration;
    }

    /**
     * <p>
     * Scheduled query target store configuration.
     * </p>
     * 
     * @return Scheduled query target store configuration.
     */
    public final TargetConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    /**
     * <p>
     * IAM role that Timestream uses to run the schedule query.
     * </p>
     * 
     * @return IAM role that Timestream uses to run the schedule query.
     */
    public final String scheduledQueryExecutionRoleArn() {
        return scheduledQueryExecutionRoleArn;
    }

    /**
     * <p>
     * A customer provided KMS key used to encrypt the scheduled query resource.
     * </p>
     * 
     * @return A customer provided KMS key used to encrypt the scheduled query resource.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Error-reporting configuration for the scheduled query.
     * </p>
     * 
     * @return Error-reporting configuration for the scheduled query.
     */
    public final ErrorReportConfiguration errorReportConfiguration() {
        return errorReportConfiguration;
    }

    /**
     * <p>
     * Runtime summary for the last scheduled query run.
     * </p>
     * 
     * @return Runtime summary for the last scheduled query run.
     */
    public final ScheduledQueryRunSummary lastRunSummary() {
        return lastRunSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecentlyFailedRuns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecentlyFailedRuns() {
        return recentlyFailedRuns != null && !(recentlyFailedRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Runtime summary for the last five failed scheduled query runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecentlyFailedRuns} method.
     * </p>
     * 
     * @return Runtime summary for the last five failed scheduled query runs.
     */
    public final List<ScheduledQueryRunSummary> recentlyFailedRuns() {
        return recentlyFailedRuns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(previousInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledQueryExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(errorReportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecentlyFailedRuns() ? recentlyFailedRuns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQueryDescription)) {
            return false;
        }
        ScheduledQueryDescription other = (ScheduledQueryDescription) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(queryString(), other.queryString()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(previousInvocationTime(), other.previousInvocationTime())
                && Objects.equals(nextInvocationTime(), other.nextInvocationTime())
                && Objects.equals(scheduleConfiguration(), other.scheduleConfiguration())
                && Objects.equals(notificationConfiguration(), other.notificationConfiguration())
                && Objects.equals(targetConfiguration(), other.targetConfiguration())
                && Objects.equals(scheduledQueryExecutionRoleArn(), other.scheduledQueryExecutionRoleArn())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(errorReportConfiguration(), other.errorReportConfiguration())
                && Objects.equals(lastRunSummary(), other.lastRunSummary())
                && hasRecentlyFailedRuns() == other.hasRecentlyFailedRuns()
                && Objects.equals(recentlyFailedRuns(), other.recentlyFailedRuns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledQueryDescription").add("Arn", arn()).add("Name", name())
                .add("QueryString", queryString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreationTime", creationTime()).add("State", stateAsString())
                .add("PreviousInvocationTime", previousInvocationTime()).add("NextInvocationTime", nextInvocationTime())
                .add("ScheduleConfiguration", scheduleConfiguration())
                .add("NotificationConfiguration", notificationConfiguration()).add("TargetConfiguration", targetConfiguration())
                .add("ScheduledQueryExecutionRoleArn", scheduledQueryExecutionRoleArn()).add("KmsKeyId", kmsKeyId())
                .add("ErrorReportConfiguration", errorReportConfiguration()).add("LastRunSummary", lastRunSummary())
                .add("RecentlyFailedRuns", hasRecentlyFailedRuns() ? recentlyFailedRuns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "PreviousInvocationTime":
            return Optional.ofNullable(clazz.cast(previousInvocationTime()));
        case "NextInvocationTime":
            return Optional.ofNullable(clazz.cast(nextInvocationTime()));
        case "ScheduleConfiguration":
            return Optional.ofNullable(clazz.cast(scheduleConfiguration()));
        case "NotificationConfiguration":
            return Optional.ofNullable(clazz.cast(notificationConfiguration()));
        case "TargetConfiguration":
            return Optional.ofNullable(clazz.cast(targetConfiguration()));
        case "ScheduledQueryExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(scheduledQueryExecutionRoleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ErrorReportConfiguration":
            return Optional.ofNullable(clazz.cast(errorReportConfiguration()));
        case "LastRunSummary":
            return Optional.ofNullable(clazz.cast(lastRunSummary()));
        case "RecentlyFailedRuns":
            return Optional.ofNullable(clazz.cast(recentlyFailedRuns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQueryDescription, T> g) {
        return obj -> g.apply((ScheduledQueryDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledQueryDescription> {
        /**
         * <p>
         * Scheduled query ARN.
         * </p>
         * 
         * @param arn
         *        Scheduled query ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Name of the scheduled query.
         * </p>
         * 
         * @param name
         *        Name of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The query to be run.
         * </p>
         * 
         * @param queryString
         *        The query to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * Creation time of the scheduled query.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * State of the scheduled query.
         * </p>
         * 
         * @param state
         *        State of the scheduled query.
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(String state);

        /**
         * <p>
         * State of the scheduled query.
         * </p>
         * 
         * @param state
         *        State of the scheduled query.
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(ScheduledQueryState state);

        /**
         * <p>
         * Last time the query was run.
         * </p>
         * 
         * @param previousInvocationTime
         *        Last time the query was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousInvocationTime(Instant previousInvocationTime);

        /**
         * <p>
         * The next time the scheduled query is scheduled to run.
         * </p>
         * 
         * @param nextInvocationTime
         *        The next time the scheduled query is scheduled to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextInvocationTime(Instant nextInvocationTime);

        /**
         * <p>
         * Schedule configuration.
         * </p>
         * 
         * @param scheduleConfiguration
         *        Schedule configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration);

        /**
         * <p>
         * Schedule configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleConfiguration(ScheduleConfiguration)}.
         * 
         * @param scheduleConfiguration
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfiguration(ScheduleConfiguration)
         */
        default Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return scheduleConfiguration(ScheduleConfiguration.builder().applyMutation(scheduleConfiguration).build());
        }

        /**
         * <p>
         * Notification configuration.
         * </p>
         * 
         * @param notificationConfiguration
         *        Notification configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfiguration(NotificationConfiguration notificationConfiguration);

        /**
         * <p>
         * Notification configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationConfiguration.Builder}
         * avoiding the need to create one manually via {@link NotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationConfiguration(NotificationConfiguration)}.
         * 
         * @param notificationConfiguration
         *        a consumer that will call methods on {@link NotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfiguration(NotificationConfiguration)
         */
        default Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return notificationConfiguration(NotificationConfiguration.builder().applyMutation(notificationConfiguration).build());
        }

        /**
         * <p>
         * Scheduled query target store configuration.
         * </p>
         * 
         * @param targetConfiguration
         *        Scheduled query target store configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(TargetConfiguration targetConfiguration);

        /**
         * <p>
         * Scheduled query target store configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetConfiguration.Builder} avoiding the
         * need to create one manually via {@link TargetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #targetConfiguration(TargetConfiguration)}.
         * 
         * @param targetConfiguration
         *        a consumer that will call methods on {@link TargetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfiguration(TargetConfiguration)
         */
        default Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return targetConfiguration(TargetConfiguration.builder().applyMutation(targetConfiguration).build());
        }

        /**
         * <p>
         * IAM role that Timestream uses to run the schedule query.
         * </p>
         * 
         * @param scheduledQueryExecutionRoleArn
         *        IAM role that Timestream uses to run the schedule query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn);

        /**
         * <p>
         * A customer provided KMS key used to encrypt the scheduled query resource.
         * </p>
         * 
         * @param kmsKeyId
         *        A customer provided KMS key used to encrypt the scheduled query resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Error-reporting configuration for the scheduled query.
         * </p>
         * 
         * @param errorReportConfiguration
         *        Error-reporting configuration for the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration);

        /**
         * <p>
         * Error-reporting configuration for the scheduled query.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorReportConfiguration.Builder}
         * avoiding the need to create one manually via {@link ErrorReportConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorReportConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #errorReportConfiguration(ErrorReportConfiguration)}.
         * 
         * @param errorReportConfiguration
         *        a consumer that will call methods on {@link ErrorReportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorReportConfiguration(ErrorReportConfiguration)
         */
        default Builder errorReportConfiguration(Consumer<ErrorReportConfiguration.Builder> errorReportConfiguration) {
            return errorReportConfiguration(ErrorReportConfiguration.builder().applyMutation(errorReportConfiguration).build());
        }

        /**
         * <p>
         * Runtime summary for the last scheduled query run.
         * </p>
         * 
         * @param lastRunSummary
         *        Runtime summary for the last scheduled query run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunSummary(ScheduledQueryRunSummary lastRunSummary);

        /**
         * <p>
         * Runtime summary for the last scheduled query run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduledQueryRunSummary.Builder}
         * avoiding the need to create one manually via {@link ScheduledQueryRunSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduledQueryRunSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #lastRunSummary(ScheduledQueryRunSummary)}.
         * 
         * @param lastRunSummary
         *        a consumer that will call methods on {@link ScheduledQueryRunSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastRunSummary(ScheduledQueryRunSummary)
         */
        default Builder lastRunSummary(Consumer<ScheduledQueryRunSummary.Builder> lastRunSummary) {
            return lastRunSummary(ScheduledQueryRunSummary.builder().applyMutation(lastRunSummary).build());
        }

        /**
         * <p>
         * Runtime summary for the last five failed scheduled query runs.
         * </p>
         * 
         * @param recentlyFailedRuns
         *        Runtime summary for the last five failed scheduled query runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recentlyFailedRuns(Collection<ScheduledQueryRunSummary> recentlyFailedRuns);

        /**
         * <p>
         * Runtime summary for the last five failed scheduled query runs.
         * </p>
         * 
         * @param recentlyFailedRuns
         *        Runtime summary for the last five failed scheduled query runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recentlyFailedRuns(ScheduledQueryRunSummary... recentlyFailedRuns);

        /**
         * <p>
         * Runtime summary for the last five failed scheduled query runs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #recentlyFailedRuns(List<ScheduledQueryRunSummary>)}.
         * 
         * @param recentlyFailedRuns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recentlyFailedRuns(java.util.Collection<ScheduledQueryRunSummary>)
         */
        Builder recentlyFailedRuns(Consumer<ScheduledQueryRunSummary.Builder>... recentlyFailedRuns);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String queryString;

        private Instant creationTime;

        private String state;

        private Instant previousInvocationTime;

        private Instant nextInvocationTime;

        private ScheduleConfiguration scheduleConfiguration;

        private NotificationConfiguration notificationConfiguration;

        private TargetConfiguration targetConfiguration;

        private String scheduledQueryExecutionRoleArn;

        private String kmsKeyId;

        private ErrorReportConfiguration errorReportConfiguration;

        private ScheduledQueryRunSummary lastRunSummary;

        private List<ScheduledQueryRunSummary> recentlyFailedRuns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQueryDescription model) {
            arn(model.arn);
            name(model.name);
            queryString(model.queryString);
            creationTime(model.creationTime);
            state(model.state);
            previousInvocationTime(model.previousInvocationTime);
            nextInvocationTime(model.nextInvocationTime);
            scheduleConfiguration(model.scheduleConfiguration);
            notificationConfiguration(model.notificationConfiguration);
            targetConfiguration(model.targetConfiguration);
            scheduledQueryExecutionRoleArn(model.scheduledQueryExecutionRoleArn);
            kmsKeyId(model.kmsKeyId);
            errorReportConfiguration(model.errorReportConfiguration);
            lastRunSummary(model.lastRunSummary);
            recentlyFailedRuns(model.recentlyFailedRuns);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledQueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getPreviousInvocationTime() {
            return previousInvocationTime;
        }

        public final void setPreviousInvocationTime(Instant previousInvocationTime) {
            this.previousInvocationTime = previousInvocationTime;
        }

        @Override
        public final Builder previousInvocationTime(Instant previousInvocationTime) {
            this.previousInvocationTime = previousInvocationTime;
            return this;
        }

        public final Instant getNextInvocationTime() {
            return nextInvocationTime;
        }

        public final void setNextInvocationTime(Instant nextInvocationTime) {
            this.nextInvocationTime = nextInvocationTime;
        }

        @Override
        public final Builder nextInvocationTime(Instant nextInvocationTime) {
            this.nextInvocationTime = nextInvocationTime;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return scheduleConfiguration != null ? scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return notificationConfiguration != null ? notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final String getScheduledQueryExecutionRoleArn() {
            return scheduledQueryExecutionRoleArn;
        }

        public final void setScheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn) {
            this.scheduledQueryExecutionRoleArn = scheduledQueryExecutionRoleArn;
        }

        @Override
        public final Builder scheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn) {
            this.scheduledQueryExecutionRoleArn = scheduledQueryExecutionRoleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final ErrorReportConfiguration.Builder getErrorReportConfiguration() {
            return errorReportConfiguration != null ? errorReportConfiguration.toBuilder() : null;
        }

        public final void setErrorReportConfiguration(ErrorReportConfiguration.BuilderImpl errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration != null ? errorReportConfiguration.build() : null;
        }

        @Override
        public final Builder errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration;
            return this;
        }

        public final ScheduledQueryRunSummary.Builder getLastRunSummary() {
            return lastRunSummary != null ? lastRunSummary.toBuilder() : null;
        }

        public final void setLastRunSummary(ScheduledQueryRunSummary.BuilderImpl lastRunSummary) {
            this.lastRunSummary = lastRunSummary != null ? lastRunSummary.build() : null;
        }

        @Override
        public final Builder lastRunSummary(ScheduledQueryRunSummary lastRunSummary) {
            this.lastRunSummary = lastRunSummary;
            return this;
        }

        public final List<ScheduledQueryRunSummary.Builder> getRecentlyFailedRuns() {
            List<ScheduledQueryRunSummary.Builder> result = ScheduledQueryRunSummaryListCopier
                    .copyToBuilder(this.recentlyFailedRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecentlyFailedRuns(Collection<ScheduledQueryRunSummary.BuilderImpl> recentlyFailedRuns) {
            this.recentlyFailedRuns = ScheduledQueryRunSummaryListCopier.copyFromBuilder(recentlyFailedRuns);
        }

        @Override
        public final Builder recentlyFailedRuns(Collection<ScheduledQueryRunSummary> recentlyFailedRuns) {
            this.recentlyFailedRuns = ScheduledQueryRunSummaryListCopier.copy(recentlyFailedRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recentlyFailedRuns(ScheduledQueryRunSummary... recentlyFailedRuns) {
            recentlyFailedRuns(Arrays.asList(recentlyFailedRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recentlyFailedRuns(Consumer<ScheduledQueryRunSummary.Builder>... recentlyFailedRuns) {
            recentlyFailedRuns(Stream.of(recentlyFailedRuns)
                    .map(c -> ScheduledQueryRunSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ScheduledQueryDescription build() {
            return new ScheduledQueryDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
