/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.timestreamquery.DefaultTimestreamQueryAsyncClient;
import software.amazon.awssdk.services.timestreamquery.DefaultTimestreamQueryBaseClientBuilder;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryAsyncClient;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryAsyncClientBuilder;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryServiceClientConfiguration;
import software.amazon.awssdk.services.timestreamquery.endpoints.TimestreamQueryEndpointProvider;

@SdkInternalApi
final class DefaultTimestreamQueryAsyncClientBuilder
extends DefaultTimestreamQueryBaseClientBuilder<TimestreamQueryAsyncClientBuilder, TimestreamQueryAsyncClient>
implements TimestreamQueryAsyncClientBuilder {
    DefaultTimestreamQueryAsyncClientBuilder() {
    }

    @Override
    public DefaultTimestreamQueryAsyncClientBuilder endpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    @Override
    public DefaultTimestreamQueryAsyncClientBuilder endpointProvider(TimestreamQueryEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TimestreamQueryAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultTimestreamQueryAsyncClientBuilder.validateClientOptions(clientConfiguration);
        TimestreamQueryServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultTimestreamQueryAsyncClient client = new DefaultTimestreamQueryAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private TimestreamQueryServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return TimestreamQueryServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

