/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;
import software.amazon.awssdk.services.timestreamquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreamquery.model.QueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.QueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.Row;

public class QueryIterable
implements SdkIterable<QueryResponse> {
    private final TimestreamQueryClient client;
    private final QueryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public QueryIterable(TimestreamQueryClient client, QueryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new QueryResponseFetcher();
    }

    public Iterator<QueryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Row> rows() {
        Function<QueryResponse, Iterator> getIterator = response -> {
            if (response != null && response.rows() != null) {
                return response.rows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class QueryResponseFetcher
    implements SyncPageFetcher<QueryResponse> {
        private QueryResponseFetcher() {
        }

        public boolean hasNextPage(QueryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public QueryResponse nextPage(QueryResponse previousPage) {
            if (previousPage == null) {
                return QueryIterable.this.client.query(QueryIterable.this.firstRequest);
            }
            return QueryIterable.this.client.query((QueryRequest)((Object)QueryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

