/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryEndpointDiscoveryCacheLoader;
import software.amazon.awssdk.services.timestreamquery.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ConflictException;
import software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.InternalServerException;
import software.amazon.awssdk.services.timestreamquery.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse;
import software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.PrepareQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.PrepareQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.QueryExecutionException;
import software.amazon.awssdk.services.timestreamquery.model.QueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.QueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamquery.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamquery.model.TagResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.TagResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryException;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.UntagResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.UntagResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ValidationException;
import software.amazon.awssdk.services.timestreamquery.paginators.ListScheduledQueriesIterable;
import software.amazon.awssdk.services.timestreamquery.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.timestreamquery.paginators.QueryIterable;
import software.amazon.awssdk.services.timestreamquery.transform.CancelQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.CreateScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DeleteScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DescribeScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.ExecuteScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.ListScheduledQueriesRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.PrepareQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.UpdateScheduledQueryRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultTimestreamQueryClient
implements TimestreamQueryClient {
    private static final Logger log = Logger.loggerFor(DefaultTimestreamQueryClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private EndpointDiscoveryRefreshCache endpointDiscoveryCache;

    protected DefaultTimestreamQueryClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        if (((Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)).booleanValue()) {
            this.endpointDiscoveryCache = EndpointDiscoveryRefreshCache.create((EndpointDiscoveryCacheLoader)TimestreamQueryEndpointDiscoveryCacheLoader.create(this));
            if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE) {
                log.warn(() -> "Endpoint discovery is enabled for this client, and an endpoint override was also specified. This will disable endpoint discovery for methods that require it, instead using the specified endpoint override. This may or may not be what you intended.");
            }
        }
    }

    public final String serviceName() {
        return "timestream";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelQueryResponse cancelQuery(CancelQueryRequest cancelQueryRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = cancelQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)cancelQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, cancelQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelQuery");
            CancelQueryResponse cancelQueryResponse = (CancelQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)cancelQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$cancelQuery$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateScheduledQueryResponse createScheduledQuery(CreateScheduledQueryRequest createScheduledQueryRequest) throws AccessDeniedException, ConflictException, InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateScheduledQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = createScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, createScheduledQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScheduledQuery");
            CreateScheduledQueryResponse createScheduledQueryResponse = (CreateScheduledQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScheduledQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createScheduledQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createScheduledQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$createScheduledQuery$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteScheduledQueryResponse deleteScheduledQuery(DeleteScheduledQueryRequest deleteScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScheduledQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = deleteScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, deleteScheduledQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScheduledQuery");
            DeleteScheduledQueryResponse deleteScheduledQueryResponse = (DeleteScheduledQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteScheduledQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteScheduledQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$deleteScheduledQuery$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamQueryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            DescribeEndpointsResponse describeEndpointsResponse = (DescribeEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$describeEndpoints$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScheduledQueryResponse describeScheduledQuery(DescribeScheduledQueryRequest describeScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScheduledQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, describeScheduledQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScheduledQuery");
            DescribeScheduledQueryResponse describeScheduledQueryResponse = (DescribeScheduledQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeScheduledQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeScheduledQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$describeScheduledQuery$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteScheduledQueryResponse executeScheduledQuery(ExecuteScheduledQueryRequest executeScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteScheduledQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = executeScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)executeScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, executeScheduledQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteScheduledQuery");
            ExecuteScheduledQueryResponse executeScheduledQueryResponse = (ExecuteScheduledQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteScheduledQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)executeScheduledQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeScheduledQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$executeScheduledQuery$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListScheduledQueriesResponse listScheduledQueries(ListScheduledQueriesRequest listScheduledQueriesRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListScheduledQueriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = listScheduledQueriesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listScheduledQueriesRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, listScheduledQueriesRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListScheduledQueries");
            ListScheduledQueriesResponse listScheduledQueriesResponse = (ListScheduledQueriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListScheduledQueries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listScheduledQueriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListScheduledQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listScheduledQueriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$listScheduledQueries$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListScheduledQueriesIterable listScheduledQueriesPaginator(ListScheduledQueriesRequest listScheduledQueriesRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return new ListScheduledQueriesIterable(this, this.applyPaginatorUserAgent(listScheduledQueriesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = listTagsForResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTagsForResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$listTagsForResource$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrepareQueryResponse prepareQuery(PrepareQueryRequest prepareQueryRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PrepareQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = prepareQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)prepareQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, prepareQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PrepareQuery");
            PrepareQueryResponse prepareQueryResponse = (PrepareQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PrepareQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)prepareQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PrepareQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return prepareQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$prepareQuery$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResponse query(QueryRequest queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = queryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)queryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, queryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Query");
            QueryResponse queryResponse = (QueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Query").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)queryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new QueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return queryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$query$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public QueryIterable queryPaginator(QueryRequest queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        return new QueryIterable(this, this.applyPaginatorUserAgent(queryRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = tagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)tagResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$tagResource$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ThrottlingException, ResourceNotFoundException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = untagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)untagResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$untagResource$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateScheduledQueryResponse updateScheduledQuery(UpdateScheduledQueryRequest updateScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        List<MetricPublisher> metricPublishers;
        boolean endpointOverridden;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateScheduledQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = updateScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(this.clientConfiguration, updateScheduledQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateScheduledQuery");
            UpdateScheduledQueryResponse updateScheduledQueryResponse = (UpdateScheduledQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateScheduledQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateScheduledQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateScheduledQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$updateScheduledQuery$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TimestreamQueryException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEndpointException").exceptionBuilderSupplier(InvalidEndpointException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryExecutionException").exceptionBuilderSupplier(QueryExecutionException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends TimestreamQueryRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.253").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((TimestreamQueryRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateScheduledQuery$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$query$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$prepareQuery$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listScheduledQueries$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeScheduledQuery$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScheduledQuery$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteScheduledQuery$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createScheduledQuery$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelQuery$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

