/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryEndpoint;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamquery.model.Endpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
class TimestreamQueryEndpointDiscoveryCacheLoader
implements EndpointDiscoveryCacheLoader {
    private final TimestreamQueryClient client;

    private TimestreamQueryEndpointDiscoveryCacheLoader(TimestreamQueryClient client) {
        this.client = client;
    }

    public static TimestreamQueryEndpointDiscoveryCacheLoader create(TimestreamQueryClient client) {
        return new TimestreamQueryEndpointDiscoveryCacheLoader(client);
    }

    public CompletableFuture<EndpointDiscoveryEndpoint> discoverEndpoint(EndpointDiscoveryRequest endpointDiscoveryRequest) {
        return CompletableFuture.supplyAsync(() -> {
            DescribeEndpointsResponse response = this.client.describeEndpoints((DescribeEndpointsRequest)((Object)((Object)DescribeEndpointsRequest.builder().build())));
            List<Endpoint> endpoints = response.endpoints();
            Validate.notEmpty(endpoints, (String)"Endpoints returned by service for endpoint discovery must not be empty.", (Object[])new Object[0]);
            Endpoint endpoint = endpoints.get(0);
            return EndpointDiscoveryEndpoint.builder().endpoint(this.toUri(endpoint.address(), endpointDiscoveryRequest.defaultEndpoint())).expirationTime(Instant.now().plus((long)endpoint.cachePeriodInMinutes(), ChronoUnit.MINUTES)).build();
        });
    }
}

