/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamquery.model.ColumnInfo;
import software.amazon.awssdk.services.timestreamquery.model.ColumnInfoListCopier;
import software.amazon.awssdk.services.timestreamquery.model.ScalarType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Type
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Type> {
    private static final SdkField<String> SCALAR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalarType").getter(Type.getter(Type::scalarTypeAsString)).setter(Type.setter(Builder::scalarType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalarType").build()}).build();
    private static final SdkField<ColumnInfo> ARRAY_COLUMN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArrayColumnInfo").getter(Type.getter(Type::arrayColumnInfo)).setter(Type.setter(Builder::arrayColumnInfo)).constructor(ColumnInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrayColumnInfo").build()}).build();
    private static final SdkField<ColumnInfo> TIME_SERIES_MEASURE_VALUE_COLUMN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSeriesMeasureValueColumnInfo").getter(Type.getter(Type::timeSeriesMeasureValueColumnInfo)).setter(Type.setter(Builder::timeSeriesMeasureValueColumnInfo)).constructor(ColumnInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesMeasureValueColumnInfo").build()}).build();
    private static final SdkField<List<ColumnInfo>> ROW_COLUMN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RowColumnInfo").getter(Type.getter(Type::rowColumnInfo)).setter(Type.setter(Builder::rowColumnInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowColumnInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALAR_TYPE_FIELD, ARRAY_COLUMN_INFO_FIELD, TIME_SERIES_MEASURE_VALUE_COLUMN_INFO_FIELD, ROW_COLUMN_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scalarType;
    private final ColumnInfo arrayColumnInfo;
    private final ColumnInfo timeSeriesMeasureValueColumnInfo;
    private final List<ColumnInfo> rowColumnInfo;

    private Type(BuilderImpl builder) {
        this.scalarType = builder.scalarType;
        this.arrayColumnInfo = builder.arrayColumnInfo;
        this.timeSeriesMeasureValueColumnInfo = builder.timeSeriesMeasureValueColumnInfo;
        this.rowColumnInfo = builder.rowColumnInfo;
    }

    public ScalarType scalarType() {
        return ScalarType.fromValue(this.scalarType);
    }

    public String scalarTypeAsString() {
        return this.scalarType;
    }

    public ColumnInfo arrayColumnInfo() {
        return this.arrayColumnInfo;
    }

    public ColumnInfo timeSeriesMeasureValueColumnInfo() {
        return this.timeSeriesMeasureValueColumnInfo;
    }

    public boolean hasRowColumnInfo() {
        return this.rowColumnInfo != null && !(this.rowColumnInfo instanceof SdkAutoConstructList);
    }

    public List<ColumnInfo> rowColumnInfo() {
        return this.rowColumnInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalarTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrayColumnInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesMeasureValueColumnInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowColumnInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Type)) {
            return false;
        }
        Type other = (Type)obj;
        return Objects.equals(this.scalarTypeAsString(), other.scalarTypeAsString()) && Objects.equals(this.arrayColumnInfo(), other.arrayColumnInfo()) && Objects.equals(this.timeSeriesMeasureValueColumnInfo(), other.timeSeriesMeasureValueColumnInfo()) && Objects.equals(this.rowColumnInfo(), other.rowColumnInfo());
    }

    public String toString() {
        return ToString.builder((String)"Type").add("ScalarType", (Object)this.scalarTypeAsString()).add("ArrayColumnInfo", (Object)this.arrayColumnInfo()).add("TimeSeriesMeasureValueColumnInfo", (Object)this.timeSeriesMeasureValueColumnInfo()).add("RowColumnInfo", this.rowColumnInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalarType": {
                return Optional.ofNullable(clazz.cast(this.scalarTypeAsString()));
            }
            case "ArrayColumnInfo": {
                return Optional.ofNullable(clazz.cast(this.arrayColumnInfo()));
            }
            case "TimeSeriesMeasureValueColumnInfo": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesMeasureValueColumnInfo()));
            }
            case "RowColumnInfo": {
                return Optional.ofNullable(clazz.cast(this.rowColumnInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Type, T> g) {
        return obj -> g.apply((Type)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scalarType;
        private ColumnInfo arrayColumnInfo;
        private ColumnInfo timeSeriesMeasureValueColumnInfo;
        private List<ColumnInfo> rowColumnInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Type model) {
            this.scalarType(model.scalarType);
            this.arrayColumnInfo(model.arrayColumnInfo);
            this.timeSeriesMeasureValueColumnInfo(model.timeSeriesMeasureValueColumnInfo);
            this.rowColumnInfo(model.rowColumnInfo);
        }

        public final String getScalarType() {
            return this.scalarType;
        }

        @Override
        public final Builder scalarType(String scalarType) {
            this.scalarType = scalarType;
            return this;
        }

        @Override
        public final Builder scalarType(ScalarType scalarType) {
            this.scalarType(scalarType == null ? null : scalarType.toString());
            return this;
        }

        public final void setScalarType(String scalarType) {
            this.scalarType = scalarType;
        }

        public final ColumnInfo.Builder getArrayColumnInfo() {
            return this.arrayColumnInfo != null ? this.arrayColumnInfo.toBuilder() : null;
        }

        @Override
        public final Builder arrayColumnInfo(ColumnInfo arrayColumnInfo) {
            this.arrayColumnInfo = arrayColumnInfo;
            return this;
        }

        public final void setArrayColumnInfo(ColumnInfo.BuilderImpl arrayColumnInfo) {
            this.arrayColumnInfo = arrayColumnInfo != null ? arrayColumnInfo.build() : null;
        }

        public final ColumnInfo.Builder getTimeSeriesMeasureValueColumnInfo() {
            return this.timeSeriesMeasureValueColumnInfo != null ? this.timeSeriesMeasureValueColumnInfo.toBuilder() : null;
        }

        @Override
        public final Builder timeSeriesMeasureValueColumnInfo(ColumnInfo timeSeriesMeasureValueColumnInfo) {
            this.timeSeriesMeasureValueColumnInfo = timeSeriesMeasureValueColumnInfo;
            return this;
        }

        public final void setTimeSeriesMeasureValueColumnInfo(ColumnInfo.BuilderImpl timeSeriesMeasureValueColumnInfo) {
            this.timeSeriesMeasureValueColumnInfo = timeSeriesMeasureValueColumnInfo != null ? timeSeriesMeasureValueColumnInfo.build() : null;
        }

        public final Collection<ColumnInfo.Builder> getRowColumnInfo() {
            return this.rowColumnInfo != null ? (Collection)this.rowColumnInfo.stream().map(ColumnInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rowColumnInfo(Collection<ColumnInfo> rowColumnInfo) {
            this.rowColumnInfo = ColumnInfoListCopier.copy(rowColumnInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowColumnInfo(ColumnInfo ... rowColumnInfo) {
            this.rowColumnInfo(Arrays.asList(rowColumnInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowColumnInfo(Consumer<ColumnInfo.Builder> ... rowColumnInfo) {
            this.rowColumnInfo(Stream.of(rowColumnInfo).map(c -> (ColumnInfo)((ColumnInfo.Builder)ColumnInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRowColumnInfo(Collection<ColumnInfo.BuilderImpl> rowColumnInfo) {
            this.rowColumnInfo = ColumnInfoListCopier.copyFromBuilder(rowColumnInfo);
        }

        public Type build() {
            return new Type(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Type> {
        public Builder scalarType(String var1);

        public Builder scalarType(ScalarType var1);

        public Builder arrayColumnInfo(ColumnInfo var1);

        default public Builder arrayColumnInfo(Consumer<ColumnInfo.Builder> arrayColumnInfo) {
            return this.arrayColumnInfo((ColumnInfo)((ColumnInfo.Builder)ColumnInfo.builder().applyMutation(arrayColumnInfo)).build());
        }

        public Builder timeSeriesMeasureValueColumnInfo(ColumnInfo var1);

        default public Builder timeSeriesMeasureValueColumnInfo(Consumer<ColumnInfo.Builder> timeSeriesMeasureValueColumnInfo) {
            return this.timeSeriesMeasureValueColumnInfo((ColumnInfo)((ColumnInfo.Builder)ColumnInfo.builder().applyMutation(timeSeriesMeasureValueColumnInfo)).build());
        }

        public Builder rowColumnInfo(Collection<ColumnInfo> var1);

        public Builder rowColumnInfo(ColumnInfo ... var1);

        public Builder rowColumnInfo(Consumer<ColumnInfo.Builder> ... var1);
    }
}

