/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentMetadata> {
    private static final SdkField<Integer> PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DocumentMetadata.getter(DocumentMetadata::pages)).setter(DocumentMetadata.setter(Builder::pages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer pages;

    private DocumentMetadata(BuilderImpl builder) {
        this.pages = builder.pages;
    }

    public Integer pages() {
        return this.pages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata)obj;
        return Objects.equals(this.pages(), other.pages());
    }

    public String toString() {
        return ToString.builder((String)"DocumentMetadata").add("Pages", (Object)this.pages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pages": {
                return Optional.ofNullable(clazz.cast(this.pages()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadata, T> g) {
        return obj -> g.apply((DocumentMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer pages;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadata model) {
            this.pages(model.pages);
        }

        public final Integer getPages() {
            return this.pages;
        }

        @Override
        public final Builder pages(Integer pages) {
            this.pages = pages;
            return this;
        }

        public final void setPages(Integer pages) {
            this.pages = pages;
        }

        public DocumentMetadata build() {
            return new DocumentMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentMetadata> {
        public Builder pages(Integer var1);
    }
}

