/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.IdListCopier;
import software.amazon.awssdk.services.textract.model.RelationshipType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Relationship
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Relationship> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Relationship.getter(Relationship::typeAsString)).setter(Relationship.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<String>> IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Relationship.getter(Relationship::ids)).setter(Relationship.setter(Builder::ids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<String> ids;

    private Relationship(BuilderImpl builder) {
        this.type = builder.type;
        this.ids = builder.ids;
    }

    public RelationshipType type() {
        return RelationshipType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public List<String> ids() {
        return this.ids;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ids());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.ids(), other.ids());
    }

    public String toString() {
        return ToString.builder((String)"Relationship").add("Type", (Object)this.typeAsString()).add("Ids", this.ids()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Ids": {
                return Optional.ofNullable(clazz.cast(this.ids()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Relationship, T> g) {
        return obj -> g.apply((Relationship)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Relationship model) {
            this.type(model.type);
            this.ids(model.ids);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RelationshipType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<String> getIds() {
            return this.ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = IdListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = IdListCopier.copy(ids);
        }

        public Relationship build() {
            return new Relationship(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Relationship> {
        public Builder type(String var1);

        public Builder type(RelationshipType var1);

        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);
    }
}

