/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.PagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Warning
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Warning> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Warning.getter(Warning::errorCode)).setter(Warning.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<List<Integer>> PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Warning.getter(Warning::pages)).setter(Warning.setter(Builder::pages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, PAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final List<Integer> pages;

    private Warning(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.pages = builder.pages;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public List<Integer> pages() {
        return this.pages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.pages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Warning)) {
            return false;
        }
        Warning other = (Warning)obj;
        return Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.pages(), other.pages());
    }

    public String toString() {
        return ToString.builder((String)"Warning").add("ErrorCode", (Object)this.errorCode()).add("Pages", this.pages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "Pages": {
                return Optional.ofNullable(clazz.cast(this.pages()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Warning, T> g) {
        return obj -> g.apply((Warning)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private List<Integer> pages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Warning model) {
            this.errorCode(model.errorCode);
            this.pages(model.pages);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final Collection<Integer> getPages() {
            return this.pages;
        }

        @Override
        public final Builder pages(Collection<Integer> pages) {
            this.pages = PagesCopier.copy(pages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(Integer ... pages) {
            this.pages(Arrays.asList(pages));
            return this;
        }

        public final void setPages(Collection<Integer> pages) {
            this.pages = PagesCopier.copy(pages);
        }

        public Warning build() {
            return new Warning(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Warning> {
        public Builder errorCode(String var1);

        public Builder pages(Collection<Integer> var1);

        public Builder pages(Integer ... var1);
    }
}

