/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAdaptersRequest extends TextractRequest implements
        ToCopyableBuilder<ListAdaptersRequest.Builder, ListAdaptersRequest> {
    private static final SdkField<Instant> AFTER_CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AfterCreationTime").getter(getter(ListAdaptersRequest::afterCreationTime))
            .setter(setter(Builder::afterCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterCreationTime").build()).build();

    private static final SdkField<Instant> BEFORE_CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BeforeCreationTime").getter(getter(ListAdaptersRequest::beforeCreationTime))
            .setter(setter(Builder::beforeCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeforeCreationTime").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAdaptersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAdaptersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_CREATION_TIME_FIELD,
            BEFORE_CREATION_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant afterCreationTime;

    private final Instant beforeCreationTime;

    private final Integer maxResults;

    private final String nextToken;

    private ListAdaptersRequest(BuilderImpl builder) {
        super(builder);
        this.afterCreationTime = builder.afterCreationTime;
        this.beforeCreationTime = builder.beforeCreationTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Specifies the lower bound for the ListAdapters operation. Ensures ListAdapters returns only adapters created
     * after the specified creation time.
     * </p>
     * 
     * @return Specifies the lower bound for the ListAdapters operation. Ensures ListAdapters returns only adapters
     *         created after the specified creation time.
     */
    public final Instant afterCreationTime() {
        return afterCreationTime;
    }

    /**
     * <p>
     * Specifies the upper bound for the ListAdapters operation. Ensures ListAdapters returns only adapters created
     * before the specified creation time.
     * </p>
     * 
     * @return Specifies the upper bound for the ListAdapters operation. Ensures ListAdapters returns only adapters
     *         created before the specified creation time.
     */
    public final Instant beforeCreationTime() {
        return beforeCreationTime;
    }

    /**
     * <p>
     * The maximum number of results to return when listing adapters.
     * </p>
     * 
     * @return The maximum number of results to return when listing adapters.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Identifies the next page of results to return when listing adapters.
     * </p>
     * 
     * @return Identifies the next page of results to return when listing adapters.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(afterCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(beforeCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAdaptersRequest)) {
            return false;
        }
        ListAdaptersRequest other = (ListAdaptersRequest) obj;
        return Objects.equals(afterCreationTime(), other.afterCreationTime())
                && Objects.equals(beforeCreationTime(), other.beforeCreationTime())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAdaptersRequest").add("AfterCreationTime", afterCreationTime())
                .add("BeforeCreationTime", beforeCreationTime()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AfterCreationTime":
            return Optional.ofNullable(clazz.cast(afterCreationTime()));
        case "BeforeCreationTime":
            return Optional.ofNullable(clazz.cast(beforeCreationTime()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AfterCreationTime", AFTER_CREATION_TIME_FIELD);
        map.put("BeforeCreationTime", BEFORE_CREATION_TIME_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAdaptersRequest, T> g) {
        return obj -> g.apply((ListAdaptersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TextractRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAdaptersRequest> {
        /**
         * <p>
         * Specifies the lower bound for the ListAdapters operation. Ensures ListAdapters returns only adapters created
         * after the specified creation time.
         * </p>
         * 
         * @param afterCreationTime
         *        Specifies the lower bound for the ListAdapters operation. Ensures ListAdapters returns only adapters
         *        created after the specified creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterCreationTime(Instant afterCreationTime);

        /**
         * <p>
         * Specifies the upper bound for the ListAdapters operation. Ensures ListAdapters returns only adapters created
         * before the specified creation time.
         * </p>
         * 
         * @param beforeCreationTime
         *        Specifies the upper bound for the ListAdapters operation. Ensures ListAdapters returns only adapters
         *        created before the specified creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeCreationTime(Instant beforeCreationTime);

        /**
         * <p>
         * The maximum number of results to return when listing adapters.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return when listing adapters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Identifies the next page of results to return when listing adapters.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return when listing adapters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TextractRequest.BuilderImpl implements Builder {
        private Instant afterCreationTime;

        private Instant beforeCreationTime;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAdaptersRequest model) {
            super(model);
            afterCreationTime(model.afterCreationTime);
            beforeCreationTime(model.beforeCreationTime);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Instant getAfterCreationTime() {
            return afterCreationTime;
        }

        public final void setAfterCreationTime(Instant afterCreationTime) {
            this.afterCreationTime = afterCreationTime;
        }

        @Override
        public final Builder afterCreationTime(Instant afterCreationTime) {
            this.afterCreationTime = afterCreationTime;
            return this;
        }

        public final Instant getBeforeCreationTime() {
            return beforeCreationTime;
        }

        public final void setBeforeCreationTime(Instant beforeCreationTime) {
            this.beforeCreationTime = beforeCreationTime;
        }

        @Override
        public final Builder beforeCreationTime(Instant beforeCreationTime) {
            this.beforeCreationTime = beforeCreationTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAdaptersRequest build() {
            return new ListAdaptersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
