/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Breakdown of detected information, seperated into the catagories Type, LabelDetection, and ValueDetection
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpenseField implements SdkPojo, Serializable, ToCopyableBuilder<ExpenseField.Builder, ExpenseField> {
    private static final SdkField<ExpenseType> TYPE_FIELD = SdkField.<ExpenseType> builder(MarshallingType.SDK_POJO)
            .memberName("Type").getter(getter(ExpenseField::type)).setter(setter(Builder::type))
            .constructor(ExpenseType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<ExpenseDetection> LABEL_DETECTION_FIELD = SdkField
            .<ExpenseDetection> builder(MarshallingType.SDK_POJO).memberName("LabelDetection")
            .getter(getter(ExpenseField::labelDetection)).setter(setter(Builder::labelDetection))
            .constructor(ExpenseDetection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelDetection").build()).build();

    private static final SdkField<ExpenseDetection> VALUE_DETECTION_FIELD = SdkField
            .<ExpenseDetection> builder(MarshallingType.SDK_POJO).memberName("ValueDetection")
            .getter(getter(ExpenseField::valueDetection)).setter(setter(Builder::valueDetection))
            .constructor(ExpenseDetection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueDetection").build()).build();

    private static final SdkField<Integer> PAGE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageNumber").getter(getter(ExpenseField::pageNumber)).setter(setter(Builder::pageNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()).build();

    private static final SdkField<ExpenseCurrency> CURRENCY_FIELD = SdkField.<ExpenseCurrency> builder(MarshallingType.SDK_POJO)
            .memberName("Currency").getter(getter(ExpenseField::currency)).setter(setter(Builder::currency))
            .constructor(ExpenseCurrency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()).build();

    private static final SdkField<List<ExpenseGroupProperty>> GROUP_PROPERTIES_FIELD = SdkField
            .<List<ExpenseGroupProperty>> builder(MarshallingType.LIST)
            .memberName("GroupProperties")
            .getter(getter(ExpenseField::groupProperties))
            .setter(setter(Builder::groupProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExpenseGroupProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExpenseGroupProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            LABEL_DETECTION_FIELD, VALUE_DETECTION_FIELD, PAGE_NUMBER_FIELD, CURRENCY_FIELD, GROUP_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ExpenseType type;

    private final ExpenseDetection labelDetection;

    private final ExpenseDetection valueDetection;

    private final Integer pageNumber;

    private final ExpenseCurrency currency;

    private final List<ExpenseGroupProperty> groupProperties;

    private ExpenseField(BuilderImpl builder) {
        this.type = builder.type;
        this.labelDetection = builder.labelDetection;
        this.valueDetection = builder.valueDetection;
        this.pageNumber = builder.pageNumber;
        this.currency = builder.currency;
        this.groupProperties = builder.groupProperties;
    }

    /**
     * <p>
     * The implied label of a detected element. Present alongside LabelDetection for explicit elements.
     * </p>
     * 
     * @return The implied label of a detected element. Present alongside LabelDetection for explicit elements.
     */
    public final ExpenseType type() {
        return type;
    }

    /**
     * <p>
     * The explicitly stated label of a detected element.
     * </p>
     * 
     * @return The explicitly stated label of a detected element.
     */
    public final ExpenseDetection labelDetection() {
        return labelDetection;
    }

    /**
     * <p>
     * The value of a detected element. Present in explicit and implicit elements.
     * </p>
     * 
     * @return The value of a detected element. Present in explicit and implicit elements.
     */
    public final ExpenseDetection valueDetection() {
        return valueDetection;
    }

    /**
     * <p>
     * The page number the value was detected on.
     * </p>
     * 
     * @return The page number the value was detected on.
     */
    public final Integer pageNumber() {
        return pageNumber;
    }

    /**
     * <p>
     * Shows the kind of currency, both the code and confidence associated with any monatary value detected.
     * </p>
     * 
     * @return Shows the kind of currency, both the code and confidence associated with any monatary value detected.
     */
    public final ExpenseCurrency currency() {
        return currency;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupProperties() {
        return groupProperties != null && !(groupProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Shows which group a response object belongs to, such as whether an address line belongs to the vendor's address
     * or the recipent's address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupProperties} method.
     * </p>
     * 
     * @return Shows which group a response object belongs to, such as whether an address line belongs to the vendor's
     *         address or the recipent's address.
     */
    public final List<ExpenseGroupProperty> groupProperties() {
        return groupProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(labelDetection());
        hashCode = 31 * hashCode + Objects.hashCode(valueDetection());
        hashCode = 31 * hashCode + Objects.hashCode(pageNumber());
        hashCode = 31 * hashCode + Objects.hashCode(currency());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupProperties() ? groupProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseField)) {
            return false;
        }
        ExpenseField other = (ExpenseField) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(labelDetection(), other.labelDetection())
                && Objects.equals(valueDetection(), other.valueDetection()) && Objects.equals(pageNumber(), other.pageNumber())
                && Objects.equals(currency(), other.currency()) && hasGroupProperties() == other.hasGroupProperties()
                && Objects.equals(groupProperties(), other.groupProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpenseField").add("Type", type()).add("LabelDetection", labelDetection())
                .add("ValueDetection", valueDetection()).add("PageNumber", pageNumber()).add("Currency", currency())
                .add("GroupProperties", hasGroupProperties() ? groupProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "LabelDetection":
            return Optional.ofNullable(clazz.cast(labelDetection()));
        case "ValueDetection":
            return Optional.ofNullable(clazz.cast(valueDetection()));
        case "PageNumber":
            return Optional.ofNullable(clazz.cast(pageNumber()));
        case "Currency":
            return Optional.ofNullable(clazz.cast(currency()));
        case "GroupProperties":
            return Optional.ofNullable(clazz.cast(groupProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("LabelDetection", LABEL_DETECTION_FIELD);
        map.put("ValueDetection", VALUE_DETECTION_FIELD);
        map.put("PageNumber", PAGE_NUMBER_FIELD);
        map.put("Currency", CURRENCY_FIELD);
        map.put("GroupProperties", GROUP_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpenseField, T> g) {
        return obj -> g.apply((ExpenseField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpenseField> {
        /**
         * <p>
         * The implied label of a detected element. Present alongside LabelDetection for explicit elements.
         * </p>
         * 
         * @param type
         *        The implied label of a detected element. Present alongside LabelDetection for explicit elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(ExpenseType type);

        /**
         * <p>
         * The implied label of a detected element. Present alongside LabelDetection for explicit elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpenseType.Builder} avoiding the need to
         * create one manually via {@link ExpenseType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpenseType.Builder#build()} is called immediately and its result
         * is passed to {@link #type(ExpenseType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link ExpenseType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(ExpenseType)
         */
        default Builder type(Consumer<ExpenseType.Builder> type) {
            return type(ExpenseType.builder().applyMutation(type).build());
        }

        /**
         * <p>
         * The explicitly stated label of a detected element.
         * </p>
         * 
         * @param labelDetection
         *        The explicitly stated label of a detected element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelDetection(ExpenseDetection labelDetection);

        /**
         * <p>
         * The explicitly stated label of a detected element.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpenseDetection.Builder} avoiding the
         * need to create one manually via {@link ExpenseDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpenseDetection.Builder#build()} is called immediately and its
         * result is passed to {@link #labelDetection(ExpenseDetection)}.
         * 
         * @param labelDetection
         *        a consumer that will call methods on {@link ExpenseDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelDetection(ExpenseDetection)
         */
        default Builder labelDetection(Consumer<ExpenseDetection.Builder> labelDetection) {
            return labelDetection(ExpenseDetection.builder().applyMutation(labelDetection).build());
        }

        /**
         * <p>
         * The value of a detected element. Present in explicit and implicit elements.
         * </p>
         * 
         * @param valueDetection
         *        The value of a detected element. Present in explicit and implicit elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueDetection(ExpenseDetection valueDetection);

        /**
         * <p>
         * The value of a detected element. Present in explicit and implicit elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpenseDetection.Builder} avoiding the
         * need to create one manually via {@link ExpenseDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpenseDetection.Builder#build()} is called immediately and its
         * result is passed to {@link #valueDetection(ExpenseDetection)}.
         * 
         * @param valueDetection
         *        a consumer that will call methods on {@link ExpenseDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueDetection(ExpenseDetection)
         */
        default Builder valueDetection(Consumer<ExpenseDetection.Builder> valueDetection) {
            return valueDetection(ExpenseDetection.builder().applyMutation(valueDetection).build());
        }

        /**
         * <p>
         * The page number the value was detected on.
         * </p>
         * 
         * @param pageNumber
         *        The page number the value was detected on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(Integer pageNumber);

        /**
         * <p>
         * Shows the kind of currency, both the code and confidence associated with any monatary value detected.
         * </p>
         * 
         * @param currency
         *        Shows the kind of currency, both the code and confidence associated with any monatary value detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currency(ExpenseCurrency currency);

        /**
         * <p>
         * Shows the kind of currency, both the code and confidence associated with any monatary value detected.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpenseCurrency.Builder} avoiding the
         * need to create one manually via {@link ExpenseCurrency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpenseCurrency.Builder#build()} is called immediately and its
         * result is passed to {@link #currency(ExpenseCurrency)}.
         * 
         * @param currency
         *        a consumer that will call methods on {@link ExpenseCurrency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currency(ExpenseCurrency)
         */
        default Builder currency(Consumer<ExpenseCurrency.Builder> currency) {
            return currency(ExpenseCurrency.builder().applyMutation(currency).build());
        }

        /**
         * <p>
         * Shows which group a response object belongs to, such as whether an address line belongs to the vendor's
         * address or the recipent's address.
         * </p>
         * 
         * @param groupProperties
         *        Shows which group a response object belongs to, such as whether an address line belongs to the
         *        vendor's address or the recipent's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupProperties(Collection<ExpenseGroupProperty> groupProperties);

        /**
         * <p>
         * Shows which group a response object belongs to, such as whether an address line belongs to the vendor's
         * address or the recipent's address.
         * </p>
         * 
         * @param groupProperties
         *        Shows which group a response object belongs to, such as whether an address line belongs to the
         *        vendor's address or the recipent's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupProperties(ExpenseGroupProperty... groupProperties);

        /**
         * <p>
         * Shows which group a response object belongs to, such as whether an address line belongs to the vendor's
         * address or the recipent's address.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.ExpenseGroupProperty.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.textract.model.ExpenseGroupProperty#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.ExpenseGroupProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #groupProperties(List<ExpenseGroupProperty>)}.
         * 
         * @param groupProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.ExpenseGroupProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupProperties(java.util.Collection<ExpenseGroupProperty>)
         */
        Builder groupProperties(Consumer<ExpenseGroupProperty.Builder>... groupProperties);
    }

    static final class BuilderImpl implements Builder {
        private ExpenseType type;

        private ExpenseDetection labelDetection;

        private ExpenseDetection valueDetection;

        private Integer pageNumber;

        private ExpenseCurrency currency;

        private List<ExpenseGroupProperty> groupProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpenseField model) {
            type(model.type);
            labelDetection(model.labelDetection);
            valueDetection(model.valueDetection);
            pageNumber(model.pageNumber);
            currency(model.currency);
            groupProperties(model.groupProperties);
        }

        public final ExpenseType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(ExpenseType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(ExpenseType type) {
            this.type = type;
            return this;
        }

        public final ExpenseDetection.Builder getLabelDetection() {
            return labelDetection != null ? labelDetection.toBuilder() : null;
        }

        public final void setLabelDetection(ExpenseDetection.BuilderImpl labelDetection) {
            this.labelDetection = labelDetection != null ? labelDetection.build() : null;
        }

        @Override
        public final Builder labelDetection(ExpenseDetection labelDetection) {
            this.labelDetection = labelDetection;
            return this;
        }

        public final ExpenseDetection.Builder getValueDetection() {
            return valueDetection != null ? valueDetection.toBuilder() : null;
        }

        public final void setValueDetection(ExpenseDetection.BuilderImpl valueDetection) {
            this.valueDetection = valueDetection != null ? valueDetection.build() : null;
        }

        @Override
        public final Builder valueDetection(ExpenseDetection valueDetection) {
            this.valueDetection = valueDetection;
            return this;
        }

        public final Integer getPageNumber() {
            return pageNumber;
        }

        public final void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final ExpenseCurrency.Builder getCurrency() {
            return currency != null ? currency.toBuilder() : null;
        }

        public final void setCurrency(ExpenseCurrency.BuilderImpl currency) {
            this.currency = currency != null ? currency.build() : null;
        }

        @Override
        public final Builder currency(ExpenseCurrency currency) {
            this.currency = currency;
            return this;
        }

        public final List<ExpenseGroupProperty.Builder> getGroupProperties() {
            List<ExpenseGroupProperty.Builder> result = ExpenseGroupPropertyListCopier.copyToBuilder(this.groupProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupProperties(Collection<ExpenseGroupProperty.BuilderImpl> groupProperties) {
            this.groupProperties = ExpenseGroupPropertyListCopier.copyFromBuilder(groupProperties);
        }

        @Override
        public final Builder groupProperties(Collection<ExpenseGroupProperty> groupProperties) {
            this.groupProperties = ExpenseGroupPropertyListCopier.copy(groupProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupProperties(ExpenseGroupProperty... groupProperties) {
            groupProperties(Arrays.asList(groupProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupProperties(Consumer<ExpenseGroupProperty.Builder>... groupProperties) {
            groupProperties(Stream.of(groupProperties).map(c -> ExpenseGroupProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExpenseField build() {
            return new ExpenseField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
