/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationMetric> {
    private static final SdkField<Float> F1_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("F1Score").getter(EvaluationMetric.getter(EvaluationMetric::f1Score)).setter(EvaluationMetric.setter(Builder::f1Score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()}).build();
    private static final SdkField<Float> PRECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Precision").getter(EvaluationMetric.getter(EvaluationMetric::precision)).setter(EvaluationMetric.setter(Builder::precision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()}).build();
    private static final SdkField<Float> RECALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Recall").getter(EvaluationMetric.getter(EvaluationMetric::recall)).setter(EvaluationMetric.setter(Builder::recall)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recall").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F1_SCORE_FIELD, PRECISION_FIELD, RECALL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Float f1Score;
    private final Float precision;
    private final Float recall;

    private EvaluationMetric(BuilderImpl builder) {
        this.f1Score = builder.f1Score;
        this.precision = builder.precision;
        this.recall = builder.recall;
    }

    public final Float f1Score() {
        return this.f1Score;
    }

    public final Float precision() {
        return this.precision;
    }

    public final Float recall() {
        return this.recall;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.f1Score());
        hashCode = 31 * hashCode + Objects.hashCode(this.precision());
        hashCode = 31 * hashCode + Objects.hashCode(this.recall());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationMetric)) {
            return false;
        }
        EvaluationMetric other = (EvaluationMetric)obj;
        return Objects.equals(this.f1Score(), other.f1Score()) && Objects.equals(this.precision(), other.precision()) && Objects.equals(this.recall(), other.recall());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationMetric").add("F1Score", (Object)this.f1Score()).add("Precision", (Object)this.precision()).add("Recall", (Object)this.recall()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "F1Score": {
                return Optional.ofNullable(clazz.cast(this.f1Score()));
            }
            case "Precision": {
                return Optional.ofNullable(clazz.cast(this.precision()));
            }
            case "Recall": {
                return Optional.ofNullable(clazz.cast(this.recall()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Float>> map = new HashMap<String, SdkField<Float>>();
        map.put("F1Score", F1_SCORE_FIELD);
        map.put("Precision", PRECISION_FIELD);
        map.put("Recall", RECALL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationMetric, T> g) {
        return obj -> g.apply((EvaluationMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float f1Score;
        private Float precision;
        private Float recall;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationMetric model) {
            this.f1Score(model.f1Score);
            this.precision(model.precision);
            this.recall(model.recall);
        }

        public final Float getF1Score() {
            return this.f1Score;
        }

        public final void setF1Score(Float f1Score) {
            this.f1Score = f1Score;
        }

        @Override
        public final Builder f1Score(Float f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        public final Float getPrecision() {
            return this.precision;
        }

        public final void setPrecision(Float precision) {
            this.precision = precision;
        }

        @Override
        public final Builder precision(Float precision) {
            this.precision = precision;
            return this;
        }

        public final Float getRecall() {
            return this.recall;
        }

        public final void setRecall(Float recall) {
            this.recall = recall;
        }

        @Override
        public final Builder recall(Float recall) {
            this.recall = recall;
            return this;
        }

        public EvaluationMetric build() {
            return new EvaluationMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationMetric> {
        public Builder f1Score(Float var1);

        public Builder precision(Float var1);

        public Builder recall(Float var1);
    }
}

