/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Holds the normalized key-value pairs returned by AnalyzeDocument, including the document type, detected text, and
 * geometry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LendingField implements SdkPojo, Serializable, ToCopyableBuilder<LendingField.Builder, LendingField> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(LendingField::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<LendingDetection> KEY_DETECTION_FIELD = SdkField
            .<LendingDetection> builder(MarshallingType.SDK_POJO).memberName("KeyDetection")
            .getter(getter(LendingField::keyDetection)).setter(setter(Builder::keyDetection))
            .constructor(LendingDetection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyDetection").build()).build();

    private static final SdkField<List<LendingDetection>> VALUE_DETECTIONS_FIELD = SdkField
            .<List<LendingDetection>> builder(MarshallingType.LIST)
            .memberName("ValueDetections")
            .getter(getter(LendingField::valueDetections))
            .setter(setter(Builder::valueDetections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueDetections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LendingDetection> builder(MarshallingType.SDK_POJO)
                                            .constructor(LendingDetection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            KEY_DETECTION_FIELD, VALUE_DETECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final LendingDetection keyDetection;

    private final List<LendingDetection> valueDetections;

    private LendingField(BuilderImpl builder) {
        this.type = builder.type;
        this.keyDetection = builder.keyDetection;
        this.valueDetections = builder.valueDetections;
    }

    /**
     * <p>
     * The type of the lending document.
     * </p>
     * 
     * @return The type of the lending document.
     */
    public final String type() {
        return type;
    }

    /**
     * Returns the value of the KeyDetection property for this object.
     * 
     * @return The value of the KeyDetection property for this object.
     */
    public final LendingDetection keyDetection() {
        return keyDetection;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValueDetections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValueDetections() {
        return valueDetections != null && !(valueDetections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of LendingDetection objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValueDetections} method.
     * </p>
     * 
     * @return An array of LendingDetection objects.
     */
    public final List<LendingDetection> valueDetections() {
        return valueDetections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(keyDetection());
        hashCode = 31 * hashCode + Objects.hashCode(hasValueDetections() ? valueDetections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingField)) {
            return false;
        }
        LendingField other = (LendingField) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(keyDetection(), other.keyDetection())
                && hasValueDetections() == other.hasValueDetections()
                && Objects.equals(valueDetections(), other.valueDetections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LendingField").add("Type", type()).add("KeyDetection", keyDetection())
                .add("ValueDetections", hasValueDetections() ? valueDetections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "KeyDetection":
            return Optional.ofNullable(clazz.cast(keyDetection()));
        case "ValueDetections":
            return Optional.ofNullable(clazz.cast(valueDetections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("KeyDetection", KEY_DETECTION_FIELD);
        map.put("ValueDetections", VALUE_DETECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LendingField, T> g) {
        return obj -> g.apply((LendingField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LendingField> {
        /**
         * <p>
         * The type of the lending document.
         * </p>
         * 
         * @param type
         *        The type of the lending document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * Sets the value of the KeyDetection property for this object.
         *
         * @param keyDetection
         *        The new value for the KeyDetection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyDetection(LendingDetection keyDetection);

        /**
         * Sets the value of the KeyDetection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LendingDetection.Builder} avoiding the
         * need to create one manually via {@link LendingDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LendingDetection.Builder#build()} is called immediately and its
         * result is passed to {@link #keyDetection(LendingDetection)}.
         * 
         * @param keyDetection
         *        a consumer that will call methods on {@link LendingDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyDetection(LendingDetection)
         */
        default Builder keyDetection(Consumer<LendingDetection.Builder> keyDetection) {
            return keyDetection(LendingDetection.builder().applyMutation(keyDetection).build());
        }

        /**
         * <p>
         * An array of LendingDetection objects.
         * </p>
         * 
         * @param valueDetections
         *        An array of LendingDetection objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueDetections(Collection<LendingDetection> valueDetections);

        /**
         * <p>
         * An array of LendingDetection objects.
         * </p>
         * 
         * @param valueDetections
         *        An array of LendingDetection objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueDetections(LendingDetection... valueDetections);

        /**
         * <p>
         * An array of LendingDetection objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.textract.model.LendingDetection.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.textract.model.LendingDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.textract.model.LendingDetection.Builder#build()} is called immediately
         * and its result is passed to {@link #valueDetections(List<LendingDetection>)}.
         * 
         * @param valueDetections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.textract.model.LendingDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueDetections(java.util.Collection<LendingDetection>)
         */
        Builder valueDetections(Consumer<LendingDetection.Builder>... valueDetections);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private LendingDetection keyDetection;

        private List<LendingDetection> valueDetections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LendingField model) {
            type(model.type);
            keyDetection(model.keyDetection);
            valueDetections(model.valueDetections);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final LendingDetection.Builder getKeyDetection() {
            return keyDetection != null ? keyDetection.toBuilder() : null;
        }

        public final void setKeyDetection(LendingDetection.BuilderImpl keyDetection) {
            this.keyDetection = keyDetection != null ? keyDetection.build() : null;
        }

        @Override
        public final Builder keyDetection(LendingDetection keyDetection) {
            this.keyDetection = keyDetection;
            return this;
        }

        public final List<LendingDetection.Builder> getValueDetections() {
            List<LendingDetection.Builder> result = LendingDetectionListCopier.copyToBuilder(this.valueDetections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValueDetections(Collection<LendingDetection.BuilderImpl> valueDetections) {
            this.valueDetections = LendingDetectionListCopier.copyFromBuilder(valueDetections);
        }

        @Override
        public final Builder valueDetections(Collection<LendingDetection> valueDetections) {
            this.valueDetections = LendingDetectionListCopier.copy(valueDetections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueDetections(LendingDetection... valueDetections) {
            valueDetections(Arrays.asList(valueDetections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueDetections(Consumer<LendingDetection.Builder>... valueDetections) {
            valueDetections(Stream.of(valueDetections).map(c -> LendingDetection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LendingField build() {
            return new LendingField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
