/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.QueryPagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Query
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Query> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(Query.getter(Query::text)).setter(Query.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(Query.getter(Query::alias)).setter(Query.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<List<String>> PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Pages").getter(Query.getter(Query::pages)).setter(Query.setter(Builder::pages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, ALIAS_FIELD, PAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Query.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final String alias;
    private final List<String> pages;

    private Query(BuilderImpl builder) {
        this.text = builder.text;
        this.alias = builder.alias;
        this.pages = builder.pages;
    }

    public final String text() {
        return this.text;
    }

    public final String alias() {
        return this.alias;
    }

    public final boolean hasPages() {
        return this.pages != null && !(this.pages instanceof SdkAutoConstructList);
    }

    public final List<String> pages() {
        return this.pages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPages() ? this.pages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.alias(), other.alias()) && this.hasPages() == other.hasPages() && Objects.equals(this.pages(), other.pages());
    }

    public final String toString() {
        return ToString.builder((String)"Query").add("Text", (Object)this.text()).add("Alias", (Object)this.alias()).add("Pages", this.hasPages() ? this.pages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "Pages": {
                return Optional.ofNullable(clazz.cast(this.pages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Text", TEXT_FIELD);
        map.put("Alias", ALIAS_FIELD);
        map.put("Pages", PAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Query, T> g) {
        return obj -> g.apply((Query)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private String alias;
        private List<String> pages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Query model) {
            this.text(model.text);
            this.alias(model.alias);
            this.pages(model.pages);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final Collection<String> getPages() {
            if (this.pages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pages;
        }

        public final void setPages(Collection<String> pages) {
            this.pages = QueryPagesCopier.copy(pages);
        }

        @Override
        public final Builder pages(Collection<String> pages) {
            this.pages = QueryPagesCopier.copy(pages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(String ... pages) {
            this.pages(Arrays.asList(pages));
            return this;
        }

        public Query build() {
            return new Query(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Query> {
        public Builder text(String var1);

        public Builder alias(String var1);

        public Builder pages(Collection<String> var1);

        public Builder pages(String ... var1);
    }
}

