/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.LendingDetection;
import software.amazon.awssdk.services.textract.model.LendingDetectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LendingField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LendingField> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(LendingField.getter(LendingField::type)).setter(LendingField.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<LendingDetection> KEY_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyDetection").getter(LendingField.getter(LendingField::keyDetection)).setter(LendingField.setter(Builder::keyDetection)).constructor(LendingDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyDetection").build()}).build();
    private static final SdkField<List<LendingDetection>> VALUE_DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValueDetections").getter(LendingField.getter(LendingField::valueDetections)).setter(LendingField.setter(Builder::valueDetections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueDetections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LendingDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, KEY_DETECTION_FIELD, VALUE_DETECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LendingField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final LendingDetection keyDetection;
    private final List<LendingDetection> valueDetections;

    private LendingField(BuilderImpl builder) {
        this.type = builder.type;
        this.keyDetection = builder.keyDetection;
        this.valueDetections = builder.valueDetections;
    }

    public final String type() {
        return this.type;
    }

    public final LendingDetection keyDetection() {
        return this.keyDetection;
    }

    public final boolean hasValueDetections() {
        return this.valueDetections != null && !(this.valueDetections instanceof SdkAutoConstructList);
    }

    public final List<LendingDetection> valueDetections() {
        return this.valueDetections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyDetection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueDetections() ? this.valueDetections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingField)) {
            return false;
        }
        LendingField other = (LendingField)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.keyDetection(), other.keyDetection()) && this.hasValueDetections() == other.hasValueDetections() && Objects.equals(this.valueDetections(), other.valueDetections());
    }

    public final String toString() {
        return ToString.builder((String)"LendingField").add("Type", (Object)this.type()).add("KeyDetection", (Object)this.keyDetection()).add("ValueDetections", this.hasValueDetections() ? this.valueDetections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "KeyDetection": {
                return Optional.ofNullable(clazz.cast(this.keyDetection()));
            }
            case "ValueDetections": {
                return Optional.ofNullable(clazz.cast(this.valueDetections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("KeyDetection", KEY_DETECTION_FIELD);
        map.put("ValueDetections", VALUE_DETECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LendingField, T> g) {
        return obj -> g.apply((LendingField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private LendingDetection keyDetection;
        private List<LendingDetection> valueDetections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LendingField model) {
            this.type(model.type);
            this.keyDetection(model.keyDetection);
            this.valueDetections(model.valueDetections);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final LendingDetection.Builder getKeyDetection() {
            return this.keyDetection != null ? this.keyDetection.toBuilder() : null;
        }

        public final void setKeyDetection(LendingDetection.BuilderImpl keyDetection) {
            this.keyDetection = keyDetection != null ? keyDetection.build() : null;
        }

        @Override
        public final Builder keyDetection(LendingDetection keyDetection) {
            this.keyDetection = keyDetection;
            return this;
        }

        public final List<LendingDetection.Builder> getValueDetections() {
            List<LendingDetection.Builder> result = LendingDetectionListCopier.copyToBuilder(this.valueDetections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValueDetections(Collection<LendingDetection.BuilderImpl> valueDetections) {
            this.valueDetections = LendingDetectionListCopier.copyFromBuilder(valueDetections);
        }

        @Override
        public final Builder valueDetections(Collection<LendingDetection> valueDetections) {
            this.valueDetections = LendingDetectionListCopier.copy(valueDetections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueDetections(LendingDetection ... valueDetections) {
            this.valueDetections(Arrays.asList(valueDetections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueDetections(Consumer<LendingDetection.Builder> ... valueDetections) {
            this.valueDetections(Stream.of(valueDetections).map(c -> (LendingDetection)((LendingDetection.Builder)LendingDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LendingField build() {
            return new LendingField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LendingField> {
        public Builder type(String var1);

        public Builder keyDetection(LendingDetection var1);

        default public Builder keyDetection(Consumer<LendingDetection.Builder> keyDetection) {
            return this.keyDetection((LendingDetection)((LendingDetection.Builder)LendingDetection.builder().applyMutation(keyDetection)).build());
        }

        public Builder valueDetections(Collection<LendingDetection> var1);

        public Builder valueDetections(LendingDetection ... var1);

        public Builder valueDetections(Consumer<LendingDetection.Builder> ... var1);
    }
}

