/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.BoundingBox;
import software.amazon.awssdk.services.textract.model.Point;
import software.amazon.awssdk.services.textract.model.PolygonCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Geometry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Geometry> {
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoundingBox").getter(Geometry.getter(Geometry::boundingBox)).setter(Geometry.setter(Builder::boundingBox)).constructor(BoundingBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()}).build();
    private static final SdkField<List<Point>> POLYGON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Polygon").getter(Geometry.getter(Geometry::polygon)).setter(Geometry.setter(Builder::polygon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polygon").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Point::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD, POLYGON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BoundingBox", BOUNDING_BOX_FIELD);
            this.put("Polygon", POLYGON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final BoundingBox boundingBox;
    private final List<Point> polygon;

    private Geometry(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.polygon = builder.polygon;
    }

    public final BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public final boolean hasPolygon() {
        return this.polygon != null && !(this.polygon instanceof SdkAutoConstructList);
    }

    public final List<Point> polygon() {
        return this.polygon;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolygon() ? this.polygon() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Geometry)) {
            return false;
        }
        Geometry other = (Geometry)obj;
        return Objects.equals(this.boundingBox(), other.boundingBox()) && this.hasPolygon() == other.hasPolygon() && Objects.equals(this.polygon(), other.polygon());
    }

    public final String toString() {
        return ToString.builder((String)"Geometry").add("BoundingBox", (Object)this.boundingBox()).add("Polygon", this.hasPolygon() ? this.polygon() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Polygon": {
                return Optional.ofNullable(clazz.cast(this.polygon()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Geometry, T> g) {
        return obj -> g.apply((Geometry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BoundingBox boundingBox;
        private List<Point> polygon = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Geometry model) {
            this.boundingBox(model.boundingBox);
            this.polygon(model.polygon);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final List<Point.Builder> getPolygon() {
            List<Point.Builder> result = PolygonCopier.copyToBuilder(this.polygon);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolygon(Collection<Point.BuilderImpl> polygon) {
            this.polygon = PolygonCopier.copyFromBuilder(polygon);
        }

        @Override
        public final Builder polygon(Collection<Point> polygon) {
            this.polygon = PolygonCopier.copy(polygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Point ... polygon) {
            this.polygon(Arrays.asList(polygon));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Consumer<Point.Builder> ... polygon) {
            this.polygon(Stream.of(polygon).map(c -> (Point)((Point.Builder)Point.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Geometry build() {
            return new Geometry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Geometry> {
        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder polygon(Collection<Point> var1);

        public Builder polygon(Point ... var1);

        public Builder polygon(Consumer<Point.Builder> ... var1);
    }
}

