/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.ValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NormalizedValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NormalizedValue> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(NormalizedValue.getter(NormalizedValue::value)).setter(NormalizedValue.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueType").getter(NormalizedValue.getter(NormalizedValue::valueTypeAsString)).setter(NormalizedValue.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, VALUE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NormalizedValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String value;
    private final String valueType;

    private NormalizedValue(BuilderImpl builder) {
        this.value = builder.value;
        this.valueType = builder.valueType;
    }

    public final String value() {
        return this.value;
    }

    public final ValueType valueType() {
        return ValueType.fromValue(this.valueType);
    }

    public final String valueTypeAsString() {
        return this.valueType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NormalizedValue)) {
            return false;
        }
        NormalizedValue other = (NormalizedValue)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.valueTypeAsString(), other.valueTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NormalizedValue").add("Value", (Object)this.value()).add("ValueType", (Object)this.valueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "ValueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Value", VALUE_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NormalizedValue, T> g) {
        return obj -> g.apply((NormalizedValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private String valueType;

        private BuilderImpl() {
        }

        private BuilderImpl(NormalizedValue model) {
            this.value(model.value);
            this.valueType(model.valueType);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getValueType() {
            return this.valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(ValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public NormalizedValue build() {
            return new NormalizedValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NormalizedValue> {
        public Builder value(String var1);

        public Builder valueType(String var1);

        public Builder valueType(ValueType var1);
    }
}

