/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.AdapterListCopier;
import software.amazon.awssdk.services.textract.model.AdapterOverview;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAdaptersResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, ListAdaptersResponse> {
    private static final SdkField<List<AdapterOverview>> ADAPTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Adapters").getter(ListAdaptersResponse.getter(ListAdaptersResponse::adapters)).setter(ListAdaptersResponse.setter(Builder::adapters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Adapters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdapterOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAdaptersResponse.getter(ListAdaptersResponse::nextToken)).setter(ListAdaptersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Adapters", ADAPTERS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AdapterOverview> adapters;
    private final String nextToken;

    private ListAdaptersResponse(BuilderImpl builder) {
        super(builder);
        this.adapters = builder.adapters;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAdapters() {
        return this.adapters != null && !(this.adapters instanceof SdkAutoConstructList);
    }

    public final List<AdapterOverview> adapters() {
        return this.adapters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdapters() ? this.adapters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAdaptersResponse)) {
            return false;
        }
        ListAdaptersResponse other = (ListAdaptersResponse)((Object)obj);
        return this.hasAdapters() == other.hasAdapters() && Objects.equals(this.adapters(), other.adapters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAdaptersResponse").add("Adapters", this.hasAdapters() ? this.adapters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Adapters": {
                return Optional.ofNullable(clazz.cast(this.adapters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAdaptersResponse, T> g) {
        return obj -> g.apply((ListAdaptersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private List<AdapterOverview> adapters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAdaptersResponse model) {
            super(model);
            this.adapters(model.adapters);
            this.nextToken(model.nextToken);
        }

        public final List<AdapterOverview.Builder> getAdapters() {
            List<AdapterOverview.Builder> result = AdapterListCopier.copyToBuilder(this.adapters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdapters(Collection<AdapterOverview.BuilderImpl> adapters) {
            this.adapters = AdapterListCopier.copyFromBuilder(adapters);
        }

        @Override
        public final Builder adapters(Collection<AdapterOverview> adapters) {
            this.adapters = AdapterListCopier.copy(adapters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adapters(AdapterOverview ... adapters) {
            this.adapters(Arrays.asList(adapters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adapters(Consumer<AdapterOverview.Builder> ... adapters) {
            this.adapters(Stream.of(adapters).map(c -> (AdapterOverview)((AdapterOverview.Builder)AdapterOverview.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAdaptersResponse build() {
            return new ListAdaptersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAdaptersResponse> {
        public Builder adapters(Collection<AdapterOverview> var1);

        public Builder adapters(AdapterOverview ... var1);

        public Builder adapters(Consumer<AdapterOverview.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

