/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.AutoUpdate;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAdapterRequest
extends TextractRequest
implements ToCopyableBuilder<Builder, UpdateAdapterRequest> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterId").getter(UpdateAdapterRequest.getter(UpdateAdapterRequest::adapterId)).setter(UpdateAdapterRequest.setter(Builder::adapterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateAdapterRequest.getter(UpdateAdapterRequest::description)).setter(UpdateAdapterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ADAPTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterName").getter(UpdateAdapterRequest.getter(UpdateAdapterRequest::adapterName)).setter(UpdateAdapterRequest.setter(Builder::adapterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterName").build()}).build();
    private static final SdkField<String> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoUpdate").getter(UpdateAdapterRequest.getter(UpdateAdapterRequest::autoUpdateAsString)).setter(UpdateAdapterRequest.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD, DESCRIPTION_FIELD, ADAPTER_NAME_FIELD, AUTO_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AdapterId", ADAPTER_ID_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("AdapterName", ADAPTER_NAME_FIELD);
            this.put("AutoUpdate", AUTO_UPDATE_FIELD);
        }
    });
    private final String adapterId;
    private final String description;
    private final String adapterName;
    private final String autoUpdate;

    private UpdateAdapterRequest(BuilderImpl builder) {
        super(builder);
        this.adapterId = builder.adapterId;
        this.description = builder.description;
        this.adapterName = builder.adapterName;
        this.autoUpdate = builder.autoUpdate;
    }

    public final String adapterId() {
        return this.adapterId;
    }

    public final String description() {
        return this.description;
    }

    public final String adapterName() {
        return this.adapterName;
    }

    public final AutoUpdate autoUpdate() {
        return AutoUpdate.fromValue(this.autoUpdate);
    }

    public final String autoUpdateAsString() {
        return this.autoUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAdapterRequest)) {
            return false;
        }
        UpdateAdapterRequest other = (UpdateAdapterRequest)((Object)obj);
        return Objects.equals(this.adapterId(), other.adapterId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.adapterName(), other.adapterName()) && Objects.equals(this.autoUpdateAsString(), other.autoUpdateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAdapterRequest").add("AdapterId", (Object)this.adapterId()).add("Description", (Object)this.description()).add("AdapterName", (Object)this.adapterName()).add("AutoUpdate", (Object)this.autoUpdateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdapterId": {
                return Optional.ofNullable(clazz.cast(this.adapterId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AdapterName": {
                return Optional.ofNullable(clazz.cast(this.adapterName()));
            }
            case "AutoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAdapterRequest, T> g) {
        return obj -> g.apply((UpdateAdapterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractRequest.BuilderImpl
    implements Builder {
        private String adapterId;
        private String description;
        private String adapterName;
        private String autoUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAdapterRequest model) {
            super(model);
            this.adapterId(model.adapterId);
            this.description(model.description);
            this.adapterName(model.adapterName);
            this.autoUpdate(model.autoUpdate);
        }

        public final String getAdapterId() {
            return this.adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAdapterName() {
            return this.adapterName;
        }

        public final void setAdapterName(String adapterName) {
            this.adapterName = adapterName;
        }

        @Override
        public final Builder adapterName(String adapterName) {
            this.adapterName = adapterName;
            return this;
        }

        public final String getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(String autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        @Override
        public final Builder autoUpdate(AutoUpdate autoUpdate) {
            this.autoUpdate(autoUpdate == null ? null : autoUpdate.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAdapterRequest build() {
            return new UpdateAdapterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TextractRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAdapterRequest> {
        public Builder adapterId(String var1);

        public Builder description(String var1);

        public Builder adapterName(String var1);

        public Builder autoUpdate(String var1);

        public Builder autoUpdate(AutoUpdate var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

