/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.ExpenseDocument;
import software.amazon.awssdk.services.textract.model.IdentityDocument;
import software.amazon.awssdk.services.textract.model.LendingDocument;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Extraction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Extraction> {
    private static final SdkField<LendingDocument> LENDING_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LendingDocument").getter(Extraction.getter(Extraction::lendingDocument)).setter(Extraction.setter(Builder::lendingDocument)).constructor(LendingDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LendingDocument").build()}).build();
    private static final SdkField<ExpenseDocument> EXPENSE_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExpenseDocument").getter(Extraction.getter(Extraction::expenseDocument)).setter(Extraction.setter(Builder::expenseDocument)).constructor(ExpenseDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpenseDocument").build()}).build();
    private static final SdkField<IdentityDocument> IDENTITY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityDocument").getter(Extraction.getter(Extraction::identityDocument)).setter(Extraction.setter(Builder::identityDocument)).constructor(IdentityDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENDING_DOCUMENT_FIELD, EXPENSE_DOCUMENT_FIELD, IDENTITY_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LendingDocument", LENDING_DOCUMENT_FIELD);
            this.put("ExpenseDocument", EXPENSE_DOCUMENT_FIELD);
            this.put("IdentityDocument", IDENTITY_DOCUMENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final LendingDocument lendingDocument;
    private final ExpenseDocument expenseDocument;
    private final IdentityDocument identityDocument;

    private Extraction(BuilderImpl builder) {
        this.lendingDocument = builder.lendingDocument;
        this.expenseDocument = builder.expenseDocument;
        this.identityDocument = builder.identityDocument;
    }

    public final LendingDocument lendingDocument() {
        return this.lendingDocument;
    }

    public final ExpenseDocument expenseDocument() {
        return this.expenseDocument;
    }

    public final IdentityDocument identityDocument() {
        return this.identityDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lendingDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.expenseDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Extraction)) {
            return false;
        }
        Extraction other = (Extraction)obj;
        return Objects.equals(this.lendingDocument(), other.lendingDocument()) && Objects.equals(this.expenseDocument(), other.expenseDocument()) && Objects.equals(this.identityDocument(), other.identityDocument());
    }

    public final String toString() {
        return ToString.builder((String)"Extraction").add("LendingDocument", (Object)this.lendingDocument()).add("ExpenseDocument", (Object)this.expenseDocument()).add("IdentityDocument", (Object)this.identityDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LendingDocument": {
                return Optional.ofNullable(clazz.cast(this.lendingDocument()));
            }
            case "ExpenseDocument": {
                return Optional.ofNullable(clazz.cast(this.expenseDocument()));
            }
            case "IdentityDocument": {
                return Optional.ofNullable(clazz.cast(this.identityDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Extraction, T> g) {
        return obj -> g.apply((Extraction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LendingDocument lendingDocument;
        private ExpenseDocument expenseDocument;
        private IdentityDocument identityDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(Extraction model) {
            this.lendingDocument(model.lendingDocument);
            this.expenseDocument(model.expenseDocument);
            this.identityDocument(model.identityDocument);
        }

        public final LendingDocument.Builder getLendingDocument() {
            return this.lendingDocument != null ? this.lendingDocument.toBuilder() : null;
        }

        public final void setLendingDocument(LendingDocument.BuilderImpl lendingDocument) {
            this.lendingDocument = lendingDocument != null ? lendingDocument.build() : null;
        }

        @Override
        public final Builder lendingDocument(LendingDocument lendingDocument) {
            this.lendingDocument = lendingDocument;
            return this;
        }

        public final ExpenseDocument.Builder getExpenseDocument() {
            return this.expenseDocument != null ? this.expenseDocument.toBuilder() : null;
        }

        public final void setExpenseDocument(ExpenseDocument.BuilderImpl expenseDocument) {
            this.expenseDocument = expenseDocument != null ? expenseDocument.build() : null;
        }

        @Override
        public final Builder expenseDocument(ExpenseDocument expenseDocument) {
            this.expenseDocument = expenseDocument;
            return this;
        }

        public final IdentityDocument.Builder getIdentityDocument() {
            return this.identityDocument != null ? this.identityDocument.toBuilder() : null;
        }

        public final void setIdentityDocument(IdentityDocument.BuilderImpl identityDocument) {
            this.identityDocument = identityDocument != null ? identityDocument.build() : null;
        }

        @Override
        public final Builder identityDocument(IdentityDocument identityDocument) {
            this.identityDocument = identityDocument;
            return this;
        }

        public Extraction build() {
            return new Extraction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Extraction> {
        public Builder lendingDocument(LendingDocument var1);

        default public Builder lendingDocument(Consumer<LendingDocument.Builder> lendingDocument) {
            return this.lendingDocument((LendingDocument)((LendingDocument.Builder)LendingDocument.builder().applyMutation(lendingDocument)).build());
        }

        public Builder expenseDocument(ExpenseDocument var1);

        default public Builder expenseDocument(Consumer<ExpenseDocument.Builder> expenseDocument) {
            return this.expenseDocument((ExpenseDocument)((ExpenseDocument.Builder)ExpenseDocument.builder().applyMutation(expenseDocument)).build());
        }

        public Builder identityDocument(IdentityDocument var1);

        default public Builder identityDocument(Consumer<IdentityDocument.Builder> identityDocument) {
            return this.identityDocument((IdentityDocument)((IdentityDocument.Builder)IdentityDocument.builder().applyMutation(identityDocument)).build());
        }
    }
}

