/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.Block;
import software.amazon.awssdk.services.textract.model.BlockListCopier;
import software.amazon.awssdk.services.textract.model.DocumentMetadata;
import software.amazon.awssdk.services.textract.model.HumanLoopActivationOutput;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzeDocumentResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, AnalyzeDocumentResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentMetadata").getter(AnalyzeDocumentResponse.getter(AnalyzeDocumentResponse::documentMetadata)).setter(AnalyzeDocumentResponse.setter(Builder::documentMetadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()}).build();
    private static final SdkField<List<Block>> BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Blocks").getter(AnalyzeDocumentResponse.getter(AnalyzeDocumentResponse::blocks)).setter(AnalyzeDocumentResponse.setter(Builder::blocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Block::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HumanLoopActivationOutput> HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopActivationOutput").getter(AnalyzeDocumentResponse.getter(AnalyzeDocumentResponse::humanLoopActivationOutput)).setter(AnalyzeDocumentResponse.setter(Builder::humanLoopActivationOutput)).constructor(HumanLoopActivationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationOutput").build()}).build();
    private static final SdkField<String> ANALYZE_DOCUMENT_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalyzeDocumentModelVersion").getter(AnalyzeDocumentResponse.getter(AnalyzeDocumentResponse::analyzeDocumentModelVersion)).setter(AnalyzeDocumentResponse.setter(Builder::analyzeDocumentModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzeDocumentModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD, BLOCKS_FIELD, HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD, ANALYZE_DOCUMENT_MODEL_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DocumentMetadata", DOCUMENT_METADATA_FIELD);
            this.put("Blocks", BLOCKS_FIELD);
            this.put("HumanLoopActivationOutput", HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD);
            this.put("AnalyzeDocumentModelVersion", ANALYZE_DOCUMENT_MODEL_VERSION_FIELD);
        }
    });
    private final DocumentMetadata documentMetadata;
    private final List<Block> blocks;
    private final HumanLoopActivationOutput humanLoopActivationOutput;
    private final String analyzeDocumentModelVersion;

    private AnalyzeDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.blocks = builder.blocks;
        this.humanLoopActivationOutput = builder.humanLoopActivationOutput;
        this.analyzeDocumentModelVersion = builder.analyzeDocumentModelVersion;
    }

    public final DocumentMetadata documentMetadata() {
        return this.documentMetadata;
    }

    public final boolean hasBlocks() {
        return this.blocks != null && !(this.blocks instanceof SdkAutoConstructList);
    }

    public final List<Block> blocks() {
        return this.blocks;
    }

    public final HumanLoopActivationOutput humanLoopActivationOutput() {
        return this.humanLoopActivationOutput;
    }

    public final String analyzeDocumentModelVersion() {
        return this.analyzeDocumentModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlocks() ? this.blocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopActivationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzeDocumentModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeDocumentResponse)) {
            return false;
        }
        AnalyzeDocumentResponse other = (AnalyzeDocumentResponse)((Object)obj);
        return Objects.equals(this.documentMetadata(), other.documentMetadata()) && this.hasBlocks() == other.hasBlocks() && Objects.equals(this.blocks(), other.blocks()) && Objects.equals(this.humanLoopActivationOutput(), other.humanLoopActivationOutput()) && Objects.equals(this.analyzeDocumentModelVersion(), other.analyzeDocumentModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyzeDocumentResponse").add("DocumentMetadata", (Object)this.documentMetadata()).add("Blocks", this.hasBlocks() ? this.blocks() : null).add("HumanLoopActivationOutput", (Object)this.humanLoopActivationOutput()).add("AnalyzeDocumentModelVersion", (Object)this.analyzeDocumentModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentMetadata()));
            }
            case "Blocks": {
                return Optional.ofNullable(clazz.cast(this.blocks()));
            }
            case "HumanLoopActivationOutput": {
                return Optional.ofNullable(clazz.cast(this.humanLoopActivationOutput()));
            }
            case "AnalyzeDocumentModelVersion": {
                return Optional.ofNullable(clazz.cast(this.analyzeDocumentModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeDocumentResponse, T> g) {
        return obj -> g.apply((AnalyzeDocumentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private DocumentMetadata documentMetadata;
        private List<Block> blocks = DefaultSdkAutoConstructList.getInstance();
        private HumanLoopActivationOutput humanLoopActivationOutput;
        private String analyzeDocumentModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeDocumentResponse model) {
            super(model);
            this.documentMetadata(model.documentMetadata);
            this.blocks(model.blocks);
            this.humanLoopActivationOutput(model.humanLoopActivationOutput);
            this.analyzeDocumentModelVersion(model.analyzeDocumentModelVersion);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return this.documentMetadata != null ? this.documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final List<Block.Builder> getBlocks() {
            List<Block.Builder> result = BlockListCopier.copyToBuilder(this.blocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlocks(Collection<Block.BuilderImpl> blocks) {
            this.blocks = BlockListCopier.copyFromBuilder(blocks);
        }

        @Override
        public final Builder blocks(Collection<Block> blocks) {
            this.blocks = BlockListCopier.copy(blocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Block ... blocks) {
            this.blocks(Arrays.asList(blocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Consumer<Block.Builder> ... blocks) {
            this.blocks(Stream.of(blocks).map(c -> (Block)((Block.Builder)Block.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final HumanLoopActivationOutput.Builder getHumanLoopActivationOutput() {
            return this.humanLoopActivationOutput != null ? this.humanLoopActivationOutput.toBuilder() : null;
        }

        public final void setHumanLoopActivationOutput(HumanLoopActivationOutput.BuilderImpl humanLoopActivationOutput) {
            this.humanLoopActivationOutput = humanLoopActivationOutput != null ? humanLoopActivationOutput.build() : null;
        }

        @Override
        public final Builder humanLoopActivationOutput(HumanLoopActivationOutput humanLoopActivationOutput) {
            this.humanLoopActivationOutput = humanLoopActivationOutput;
            return this;
        }

        public final String getAnalyzeDocumentModelVersion() {
            return this.analyzeDocumentModelVersion;
        }

        public final void setAnalyzeDocumentModelVersion(String analyzeDocumentModelVersion) {
            this.analyzeDocumentModelVersion = analyzeDocumentModelVersion;
        }

        @Override
        public final Builder analyzeDocumentModelVersion(String analyzeDocumentModelVersion) {
            this.analyzeDocumentModelVersion = analyzeDocumentModelVersion;
            return this;
        }

        @Override
        public AnalyzeDocumentResponse build() {
            return new AnalyzeDocumentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AnalyzeDocumentResponse> {
        public Builder documentMetadata(DocumentMetadata var1);

        default public Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return this.documentMetadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(documentMetadata)).build());
        }

        public Builder blocks(Collection<Block> var1);

        public Builder blocks(Block ... var1);

        public Builder blocks(Consumer<Block.Builder> ... var1);

        public Builder humanLoopActivationOutput(HumanLoopActivationOutput var1);

        default public Builder humanLoopActivationOutput(Consumer<HumanLoopActivationOutput.Builder> humanLoopActivationOutput) {
            return this.humanLoopActivationOutput((HumanLoopActivationOutput)((HumanLoopActivationOutput.Builder)HumanLoopActivationOutput.builder().applyMutation(humanLoopActivationOutput)).build());
        }

        public Builder analyzeDocumentModelVersion(String var1);
    }
}

