/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.Document;
import software.amazon.awssdk.services.textract.model.DocumentPagesCopier;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzeIdRequest
extends TextractRequest
implements ToCopyableBuilder<Builder, AnalyzeIdRequest> {
    private static final SdkField<List<Document>> DOCUMENT_PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentPages").getter(AnalyzeIdRequest.getter(AnalyzeIdRequest::documentPages)).setter(AnalyzeIdRequest.setter(Builder::documentPages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentPages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Document::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_PAGES_FIELD));
    private final List<Document> documentPages;

    private AnalyzeIdRequest(BuilderImpl builder) {
        super(builder);
        this.documentPages = builder.documentPages;
    }

    public final boolean hasDocumentPages() {
        return this.documentPages != null && !(this.documentPages instanceof SdkAutoConstructList);
    }

    public final List<Document> documentPages() {
        return this.documentPages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentPages() ? this.documentPages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeIdRequest)) {
            return false;
        }
        AnalyzeIdRequest other = (AnalyzeIdRequest)((Object)obj);
        return this.hasDocumentPages() == other.hasDocumentPages() && Objects.equals(this.documentPages(), other.documentPages());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyzeIdRequest").add("DocumentPages", this.hasDocumentPages() ? this.documentPages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentPages": {
                return Optional.ofNullable(clazz.cast(this.documentPages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeIdRequest, T> g) {
        return obj -> g.apply((AnalyzeIdRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractRequest.BuilderImpl
    implements Builder {
        private List<Document> documentPages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeIdRequest model) {
            super(model);
            this.documentPages(model.documentPages);
        }

        public final List<Document.Builder> getDocumentPages() {
            List<Document.Builder> result = DocumentPagesCopier.copyToBuilder(this.documentPages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentPages(Collection<Document.BuilderImpl> documentPages) {
            this.documentPages = DocumentPagesCopier.copyFromBuilder(documentPages);
        }

        @Override
        public final Builder documentPages(Collection<Document> documentPages) {
            this.documentPages = DocumentPagesCopier.copy(documentPages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentPages(Document ... documentPages) {
            this.documentPages(Arrays.asList(documentPages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentPages(Consumer<Document.Builder> ... documentPages) {
            this.documentPages(Stream.of(documentPages).map(c -> (Document)((Document.Builder)Document.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AnalyzeIdRequest build() {
            return new AnalyzeIdRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AnalyzeIdRequest> {
        public Builder documentPages(Collection<Document> var1);

        public Builder documentPages(Document ... var1);

        public Builder documentPages(Consumer<Document.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

