/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.textract.TextractClient;
import software.amazon.awssdk.services.textract.TextractServiceClientConfiguration;
import software.amazon.awssdk.services.textract.internal.TextractServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.textract.model.AccessDeniedException;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse;
import software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse;
import software.amazon.awssdk.services.textract.model.AnalyzeIdRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeIdResponse;
import software.amazon.awssdk.services.textract.model.BadDocumentException;
import software.amazon.awssdk.services.textract.model.ConflictException;
import software.amazon.awssdk.services.textract.model.CreateAdapterRequest;
import software.amazon.awssdk.services.textract.model.CreateAdapterResponse;
import software.amazon.awssdk.services.textract.model.CreateAdapterVersionRequest;
import software.amazon.awssdk.services.textract.model.CreateAdapterVersionResponse;
import software.amazon.awssdk.services.textract.model.DeleteAdapterRequest;
import software.amazon.awssdk.services.textract.model.DeleteAdapterResponse;
import software.amazon.awssdk.services.textract.model.DeleteAdapterVersionRequest;
import software.amazon.awssdk.services.textract.model.DeleteAdapterVersionResponse;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse;
import software.amazon.awssdk.services.textract.model.DocumentTooLargeException;
import software.amazon.awssdk.services.textract.model.GetAdapterRequest;
import software.amazon.awssdk.services.textract.model.GetAdapterResponse;
import software.amazon.awssdk.services.textract.model.GetAdapterVersionRequest;
import software.amazon.awssdk.services.textract.model.GetAdapterVersionResponse;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryRequest;
import software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryResponse;
import software.amazon.awssdk.services.textract.model.HumanLoopQuotaExceededException;
import software.amazon.awssdk.services.textract.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.textract.model.InternalServerErrorException;
import software.amazon.awssdk.services.textract.model.InvalidJobIdException;
import software.amazon.awssdk.services.textract.model.InvalidKmsKeyException;
import software.amazon.awssdk.services.textract.model.InvalidParameterException;
import software.amazon.awssdk.services.textract.model.InvalidS3ObjectException;
import software.amazon.awssdk.services.textract.model.LimitExceededException;
import software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest;
import software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse;
import software.amazon.awssdk.services.textract.model.ListAdaptersRequest;
import software.amazon.awssdk.services.textract.model.ListAdaptersResponse;
import software.amazon.awssdk.services.textract.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.textract.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.textract.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.textract.model.ResourceNotFoundException;
import software.amazon.awssdk.services.textract.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisResponse;
import software.amazon.awssdk.services.textract.model.StartLendingAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartLendingAnalysisResponse;
import software.amazon.awssdk.services.textract.model.TagResourceRequest;
import software.amazon.awssdk.services.textract.model.TagResourceResponse;
import software.amazon.awssdk.services.textract.model.TextractException;
import software.amazon.awssdk.services.textract.model.ThrottlingException;
import software.amazon.awssdk.services.textract.model.UnsupportedDocumentException;
import software.amazon.awssdk.services.textract.model.UntagResourceRequest;
import software.amazon.awssdk.services.textract.model.UntagResourceResponse;
import software.amazon.awssdk.services.textract.model.UpdateAdapterRequest;
import software.amazon.awssdk.services.textract.model.UpdateAdapterResponse;
import software.amazon.awssdk.services.textract.model.ValidationException;
import software.amazon.awssdk.services.textract.transform.AnalyzeDocumentRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.AnalyzeExpenseRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.AnalyzeIdRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.CreateAdapterRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.CreateAdapterVersionRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.DeleteAdapterRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.DeleteAdapterVersionRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.DetectDocumentTextRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetAdapterRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetAdapterVersionRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetDocumentAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetDocumentTextDetectionRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetExpenseAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetLendingAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.GetLendingAnalysisSummaryRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.ListAdapterVersionsRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.ListAdaptersRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.StartDocumentAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.StartDocumentTextDetectionRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.StartExpenseAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.StartLendingAnalysisRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.textract.transform.UpdateAdapterRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultTextractClient
implements TextractClient {
    private static final Logger log = Logger.loggerFor(DefaultTextractClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final TextractServiceClientConfiguration serviceClientConfiguration;

    protected DefaultTextractClient(TextractServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyzeDocumentResponse analyzeDocument(AnalyzeDocumentRequest analyzeDocumentRequest) throws InvalidParameterException, InvalidS3ObjectException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, HumanLoopQuotaExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AnalyzeDocumentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)analyzeDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, analyzeDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AnalyzeDocument");
            AnalyzeDocumentResponse analyzeDocumentResponse = (AnalyzeDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AnalyzeDocument").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)analyzeDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AnalyzeDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return analyzeDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$analyzeDocument$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyzeExpenseResponse analyzeExpense(AnalyzeExpenseRequest analyzeExpenseRequest) throws InvalidParameterException, InvalidS3ObjectException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AnalyzeExpenseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)analyzeExpenseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, analyzeExpenseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AnalyzeExpense");
            AnalyzeExpenseResponse analyzeExpenseResponse = (AnalyzeExpenseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AnalyzeExpense").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)analyzeExpenseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AnalyzeExpenseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return analyzeExpenseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$analyzeExpense$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyzeIdResponse analyzeID(AnalyzeIdRequest analyzeIdRequest) throws InvalidParameterException, InvalidS3ObjectException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AnalyzeIdResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)analyzeIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, analyzeIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AnalyzeID");
            AnalyzeIdResponse analyzeIdResponse = (AnalyzeIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AnalyzeID").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)analyzeIdRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AnalyzeIdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return analyzeIdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$analyzeID$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAdapterResponse createAdapter(CreateAdapterRequest createAdapterRequest) throws InvalidParameterException, AccessDeniedException, ConflictException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAdapterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAdapterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, createAdapterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAdapter");
            CreateAdapterResponse createAdapterResponse = (CreateAdapterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAdapter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAdapterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAdapterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAdapterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$createAdapter$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAdapterVersionResponse createAdapterVersion(CreateAdapterVersionRequest createAdapterVersionRequest) throws InvalidParameterException, InvalidS3ObjectException, InvalidKmsKeyException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAdapterVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAdapterVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, createAdapterVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAdapterVersion");
            CreateAdapterVersionResponse createAdapterVersionResponse = (CreateAdapterVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAdapterVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAdapterVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAdapterVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAdapterVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$createAdapterVersion$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAdapterResponse deleteAdapter(DeleteAdapterRequest deleteAdapterRequest) throws InvalidParameterException, AccessDeniedException, ConflictException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAdapterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAdapterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, deleteAdapterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAdapter");
            DeleteAdapterResponse deleteAdapterResponse = (DeleteAdapterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAdapter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAdapterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAdapterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAdapterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$deleteAdapter$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAdapterVersionResponse deleteAdapterVersion(DeleteAdapterVersionRequest deleteAdapterVersionRequest) throws InvalidParameterException, AccessDeniedException, ConflictException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAdapterVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAdapterVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, deleteAdapterVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAdapterVersion");
            DeleteAdapterVersionResponse deleteAdapterVersionResponse = (DeleteAdapterVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAdapterVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAdapterVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAdapterVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAdapterVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$deleteAdapterVersion$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectDocumentTextResponse detectDocumentText(DetectDocumentTextRequest detectDocumentTextRequest) throws InvalidParameterException, InvalidS3ObjectException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectDocumentTextResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectDocumentTextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, detectDocumentTextRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectDocumentText");
            DetectDocumentTextResponse detectDocumentTextResponse = (DetectDocumentTextResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectDocumentText").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectDocumentTextRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectDocumentTextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectDocumentTextResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$detectDocumentText$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAdapterResponse getAdapter(GetAdapterRequest getAdapterRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAdapterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAdapterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getAdapterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAdapter");
            GetAdapterResponse getAdapterResponse = (GetAdapterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAdapter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAdapterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAdapterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAdapterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getAdapter$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAdapterVersionResponse getAdapterVersion(GetAdapterVersionRequest getAdapterVersionRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAdapterVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAdapterVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getAdapterVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAdapterVersion");
            GetAdapterVersionResponse getAdapterVersionResponse = (GetAdapterVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAdapterVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAdapterVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAdapterVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAdapterVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getAdapterVersion$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDocumentAnalysisResponse getDocumentAnalysis(GetDocumentAnalysisRequest getDocumentAnalysisRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InvalidJobIdException, InternalServerErrorException, ThrottlingException, InvalidS3ObjectException, InvalidKmsKeyException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDocumentAnalysisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDocumentAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getDocumentAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDocumentAnalysis");
            GetDocumentAnalysisResponse getDocumentAnalysisResponse = (GetDocumentAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDocumentAnalysis").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDocumentAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDocumentAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDocumentAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getDocumentAnalysis$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDocumentTextDetectionResponse getDocumentTextDetection(GetDocumentTextDetectionRequest getDocumentTextDetectionRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InvalidJobIdException, InternalServerErrorException, ThrottlingException, InvalidS3ObjectException, InvalidKmsKeyException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDocumentTextDetectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDocumentTextDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getDocumentTextDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDocumentTextDetection");
            GetDocumentTextDetectionResponse getDocumentTextDetectionResponse = (GetDocumentTextDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDocumentTextDetection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDocumentTextDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDocumentTextDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDocumentTextDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getDocumentTextDetection$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetExpenseAnalysisResponse getExpenseAnalysis(GetExpenseAnalysisRequest getExpenseAnalysisRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InvalidJobIdException, InternalServerErrorException, ThrottlingException, InvalidS3ObjectException, InvalidKmsKeyException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExpenseAnalysisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExpenseAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getExpenseAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExpenseAnalysis");
            GetExpenseAnalysisResponse getExpenseAnalysisResponse = (GetExpenseAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExpenseAnalysis").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getExpenseAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetExpenseAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getExpenseAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getExpenseAnalysis$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLendingAnalysisResponse getLendingAnalysis(GetLendingAnalysisRequest getLendingAnalysisRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InvalidJobIdException, InternalServerErrorException, ThrottlingException, InvalidS3ObjectException, InvalidKmsKeyException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLendingAnalysisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLendingAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getLendingAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLendingAnalysis");
            GetLendingAnalysisResponse getLendingAnalysisResponse = (GetLendingAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLendingAnalysis").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLendingAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLendingAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLendingAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getLendingAnalysis$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLendingAnalysisSummaryResponse getLendingAnalysisSummary(GetLendingAnalysisSummaryRequest getLendingAnalysisSummaryRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InvalidJobIdException, InternalServerErrorException, ThrottlingException, InvalidS3ObjectException, InvalidKmsKeyException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLendingAnalysisSummaryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLendingAnalysisSummaryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, getLendingAnalysisSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLendingAnalysisSummary");
            GetLendingAnalysisSummaryResponse getLendingAnalysisSummaryResponse = (GetLendingAnalysisSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLendingAnalysisSummary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLendingAnalysisSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLendingAnalysisSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLendingAnalysisSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$getLendingAnalysisSummary$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAdapterVersionsResponse listAdapterVersions(ListAdapterVersionsRequest listAdapterVersionsRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAdapterVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAdapterVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, listAdapterVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAdapterVersions");
            ListAdapterVersionsResponse listAdapterVersionsResponse = (ListAdapterVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAdapterVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAdapterVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAdapterVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAdapterVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$listAdapterVersions$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAdaptersResponse listAdapters(ListAdaptersRequest listAdaptersRequest) throws InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAdaptersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAdaptersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, listAdaptersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAdapters");
            ListAdaptersResponse listAdaptersResponse = (ListAdaptersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAdapters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAdaptersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAdaptersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAdaptersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$listAdapters$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$listTagsForResource$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDocumentAnalysisResponse startDocumentAnalysis(StartDocumentAnalysisRequest startDocumentAnalysisRequest) throws InvalidParameterException, InvalidS3ObjectException, InvalidKmsKeyException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDocumentAnalysisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDocumentAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, startDocumentAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDocumentAnalysis");
            StartDocumentAnalysisResponse startDocumentAnalysisResponse = (StartDocumentAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDocumentAnalysis").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDocumentAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDocumentAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDocumentAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$startDocumentAnalysis$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDocumentTextDetectionResponse startDocumentTextDetection(StartDocumentTextDetectionRequest startDocumentTextDetectionRequest) throws InvalidParameterException, InvalidS3ObjectException, InvalidKmsKeyException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDocumentTextDetectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDocumentTextDetectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, startDocumentTextDetectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDocumentTextDetection");
            StartDocumentTextDetectionResponse startDocumentTextDetectionResponse = (StartDocumentTextDetectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDocumentTextDetection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDocumentTextDetectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDocumentTextDetectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDocumentTextDetectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$startDocumentTextDetection$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartExpenseAnalysisResponse startExpenseAnalysis(StartExpenseAnalysisRequest startExpenseAnalysisRequest) throws InvalidParameterException, InvalidS3ObjectException, InvalidKmsKeyException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartExpenseAnalysisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startExpenseAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, startExpenseAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartExpenseAnalysis");
            StartExpenseAnalysisResponse startExpenseAnalysisResponse = (StartExpenseAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartExpenseAnalysis").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startExpenseAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartExpenseAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startExpenseAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$startExpenseAnalysis$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartLendingAnalysisResponse startLendingAnalysis(StartLendingAnalysisRequest startLendingAnalysisRequest) throws InvalidParameterException, InvalidS3ObjectException, InvalidKmsKeyException, UnsupportedDocumentException, DocumentTooLargeException, BadDocumentException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, IdempotentParameterMismatchException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartLendingAnalysisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startLendingAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, startLendingAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartLendingAnalysis");
            StartLendingAnalysisResponse startLendingAnalysisResponse = (StartLendingAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartLendingAnalysis").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startLendingAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartLendingAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startLendingAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$startLendingAnalysis$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, InvalidParameterException, ServiceQuotaExceededException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$tagResource$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InvalidParameterException, AccessDeniedException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$untagResource$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAdapterResponse updateAdapter(UpdateAdapterRequest updateAdapterRequest) throws InvalidParameterException, AccessDeniedException, ConflictException, ProvisionedThroughputExceededException, InternalServerErrorException, ThrottlingException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, TextractException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAdapterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAdapterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTextractClient.resolveMetricPublishers(clientConfiguration, updateAdapterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Textract");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAdapter");
            UpdateAdapterResponse updateAdapterResponse = (UpdateAdapterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAdapter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAdapterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAdapterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAdapterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTextractClient.lambda$updateAdapter$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "textract";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        TextractServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = TextractServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TextractException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("BadDocumentException").exceptionBuilderSupplier(BadDocumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException").exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidKMSKeyException").exceptionBuilderSupplier(InvalidKmsKeyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DocumentTooLargeException").exceptionBuilderSupplier(DocumentTooLargeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedDocumentException").exceptionBuilderSupplier(UnsupportedDocumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3ObjectException").exceptionBuilderSupplier(InvalidS3ObjectException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidJobIdException").exceptionBuilderSupplier(InvalidJobIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final TextractServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateAdapter$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startLendingAnalysis$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startExpenseAnalysis$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDocumentTextDetection$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDocumentAnalysis$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAdapters$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAdapterVersions$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLendingAnalysisSummary$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLendingAnalysis$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExpenseAnalysis$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDocumentTextDetection$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDocumentAnalysis$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAdapterVersion$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAdapter$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectDocumentText$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAdapterVersion$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAdapter$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAdapterVersion$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAdapter$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$analyzeID$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$analyzeExpense$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$analyzeDocument$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

