/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDocumentTextDetectionRequest extends TextractRequest implements
        ToCopyableBuilder<GetDocumentTextDetectionRequest.Builder, GetDocumentTextDetectionRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(GetDocumentTextDetectionRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetDocumentTextDetectionRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetDocumentTextDetectionRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String jobId;

    private final Integer maxResults;

    private final String nextToken;

    private GetDocumentTextDetectionRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for the text detection job. The <code>JobId</code> is returned from
     * <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.
     * </p>
     * 
     * @return A unique identifier for the text detection job. The <code>JobId</code> is returned from
     *         <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The maximum number of results to return per paginated call. The largest value you can specify is 1,000. If you
     * specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is 1,000.
     * </p>
     * 
     * @return The maximum number of results to return per paginated call. The largest value you can specify is 1,000.
     *         If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is
     *         1,000.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of blocks.
     * </p>
     * 
     * @return If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract
     *         returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     *         blocks.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentTextDetectionRequest)) {
            return false;
        }
        GetDocumentTextDetectionRequest other = (GetDocumentTextDetectionRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDocumentTextDetectionRequest").add("JobId", jobId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentTextDetectionRequest, T> g) {
        return obj -> g.apply((GetDocumentTextDetectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDocumentTextDetectionRequest> {
        /**
         * <p>
         * A unique identifier for the text detection job. The <code>JobId</code> is returned from
         * <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.
         * </p>
         * 
         * @param jobId
         *        A unique identifier for the text detection job. The <code>JobId</code> is returned from
         *        <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The maximum number of results to return per paginated call. The largest value you can specify is 1,000. If
         * you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is 1,000.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per paginated call. The largest value you can specify is
         *        1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default
         *        value is 1,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns
         * a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract
         *        returns a pagination token in the response. You can use this pagination token to retrieve the next set
         *        of blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TextractRequest.BuilderImpl implements Builder {
        private String jobId;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentTextDetectionRequest model) {
            super(model);
            jobId(model.jobId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDocumentTextDetectionRequest build() {
            return new GetDocumentTextDetectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
